<?php
namespace PaymentExpress\PxPay2\Controller\Customer;

class Delete extends \Magento\Framework\App\Action\Action
{

    /**
     *
     * @var \Magento\Framework\View\Result\PageFactory
     */
    private $resultPageFactory;

    /**
     *
     * @var \PaymentExpress\PxPay2\Logger\DpsLogger
     */
    private $_logger;

    /**
     *
     * @var \Magento\Customer\Model\Session
     */
    private $_customerSession;

    /**
     *
     * @var \PaymentExpress\PxPay2\Helper\PaymentUtil
     */
    private $_paymentUtil;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        parent::__construct($context);
        $this->_customerSession = $this->_objectManager->get(\Magento\Customer\Model\Session::class);
        $this->_paymentUtil = $this->_objectManager->get("\PaymentExpress\PxPay2\Helper\PaymentUtil");
        $this->_logger = $this->_objectManager->get("\PaymentExpress\PxPay2\Logger\DpsLogger");
        $this->_logger->info(__METHOD__);
    }

    private function firstOrSecond($a, $b) {
        if (isset($a) && !is_null($a))
            return $a;
        return $b;
    }

    public function execute()
    {
        $this->_customerSession = $this->_objectManager->get(\Magento\Customer\Model\Session::class);
        
        $cardNumber = $this->firstOrSecond($this->getRequest()->getParam("cardNumber"), $this->getRequest()->getParam("cardnumber"));
        $expiryDate = $this->firstOrSecond($this->getRequest()->getParam('expiryDate'), $this->getRequest()->getParam('expirydate'));
        $customerId = $this->_customerSession->getCustomerId();
        
        $this->_logger->info(
            __METHOD__ . " customerId:{$customerId} cardNumber:{$cardNumber} expiryDate:{$expiryDate}"
        );
        $this->_paymentUtil->deleteCards($customerId, $cardNumber, $expiryDate);
        
        return $this->_redirect("pxpay2/customer/");
    }
}
