#!/bin/bash

echo "Run SQL commands"
odocker mysql asics < .odocker/setup.sql

git checkout -- .gitignore

echo "Run Magento commands"
odocker magento app:config:import
odocker magento deploy:mode:set developer

odocker magerun config:set web/url/use_store 1
odocker magento config:set system/security/max_session_size_admin 2560000
odocker magento config:set transactional_emails/ddg_transactional/enabled 0
odocker magento config:set rezdy_configuration/general/enabled 0
odocker magento config:set system/full_page_cache/caching_application 1

odocker magento cache:flush

echo "Run Magerun commands"
odocker magerun config:set catalog/search/engine elasticsearch7
odocker magerun config:set algoliasearch_credentials/credentials/index_prefix 'odocker_local'
odocker magerun config:set catalog/search/elasticsearch7_server_hostname elasticsearch

echo "Post installation finished. Run upgrade"
odocker magento setup:upgrade
odocker magento setup:di:compile
