define([
    'jquery',
    'moment',
    'mageUtils',
    'jquery/validate',
    'mage/translate'
], function ($, moment, utils) {
    'use strict';

    $.validator.addMethod(
        'validate-date',
        function (value, params, additionalParams) {
            let momentFormat = utils.convertToMomentFormat(additionalParams.dateFormat);
            var test = moment(value, momentFormat, true);
            this.sampleDate = moment('30/01/2000', 'DD/MM/YYYY').format(momentFormat);
            return $.mage.isEmptyNoTrim(value) || test.isValid();
        },
        function () {
            return $.mage.__('Please enter a valid date. Ex. ' + this.sampleDate);
        }
    );

    let customRules = {
        'validate-dob-one-field': [
            function (value, element, params) {
                let dateFormat = utils.convertToMomentFormat(params.dateFormat);

                if (value === '') {
                    return true;
                }
                let minYear = (new Date().getFullYear()) - 120;
                let year = moment(value, dateFormat).format('YYYY');
                if (minYear > year) {
                    this.dobErrorMessage = $.mage.__('Please enter a year greater or equal than ' + minYear + '.');
                    return false;
                }

                if (moment().isBefore(moment(value, dateFormat))) {
                    this.dobErrorMessage = $.mage.__('The Date of Birth should not be greater than today.');
                    return false;
                }

                return true;
            },
            function () {
                return this.dobErrorMessage;
            }
        ]
    };


    $.each(customRules, function (i, rule) {
        rule.unshift(i);
        $.validator.addMethod.apply($.validator, rule);
    });
});
