define([
    'jquery',
    'matchMedia',
    'Magento_Ui/js/modal/modal',
    'domReady!'
], function ($, mediaCheck) {
    'use strict';

    $.widget('overdose.sidebarToggle', {

        options: {
            mobileQuery: '(max-width: 1024px)'
        },

        classes: {
            bodyAccount: 'account',
            modal: 'account-nav',
            switcher: 'account-nav-switcher',
            open: 'account-nav-open'
        },

        selectors: {
            html: 'html',
            body: 'body',
            accountNav: '#account-nav',
            customerNav: '#customer-account-menu',
            customerNavText: 'customer-account-menu',
            navItems: '.nav.items',
            activeItem: '.current > a, .current > strong',
        },

        _create: function () {
            var _self = this,
                navItems = $(this.selectors.accountNav).find(this.selectors.navItems);

            if ($(this.selectors.body).hasClass(this.classes.bodyAccount) && navItems.length) {
                mediaCheck({
                    media: _self.options.mobileQuery,
                    entry: function () {
                        _self.reset();
                        _self.addSwitcher(navItems);
                    }
                });
            }
        },

        addSwitcher: function (navItems) {
            var activeItem = navItems.find(this.selectors.activeItem),
                activeItemText = activeItem.text().replace(/\d+/g, '');

            $('<div/>', {
                class: this.classes.switcher,
                text: activeItem.length ? activeItemText : navItems.find('.item').first().find('a').text(),
                on: {
                    click: $.proxy(this.open, this)
                }
            }).prependTo(this.selectors.accountNav);

        },

        reset: function () {
            var switcher = $('.' + this.classes.switcher);

            if (switcher.length) switcher.remove();
        },

        open: function (e) {
            e.target.classList.toggle('active');
        }

    });

    return $.overdose.sidebarToggle;
});
