define([
    'jquery',
    'ko',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/step-navigator',
], function(
    $,
    ko,
    quote,
    stepNavigator
){
    'use strict';
    return function (Component) {

        return Component.extend({
            defaults: {
                isActiveMessage: ko.observable(false)
            },

            initialize: function() {
                this._super();
                this.changedMessageState();
            },

            changedMessageState: function(){
                var shippingAddress = JSON.stringify(quote.shippingAddress()),
                    currentShippingAddress = {},
                    flag = false,
                    _self = this;

                stepNavigator.steps.subscribe(function(){
                    var activeStep = stepNavigator.getActiveItemIndex();

                    if(activeStep === 1) {
                        currentShippingAddress = JSON.stringify(quote.shippingAddress());

                        if(flag === true) {
                            var isAddressSame = shippingAddress === currentShippingAddress;

                            if(!isAddressSame) {
                                _self.isActiveMessage(true);
                                shippingAddress = currentShippingAddress;
                            } else if(isAddressSame){
                                _self.isActiveMessage(false);
                            }
                        }
                        flag = true;
                    }
                });
            }
        });
    }
});
