define([
    'Magento_Checkout/js/model/payment-service',
    'Magento_Checkout/js/checkout-data',
    'Magento_Checkout/js/action/select-payment-method'
], function (
    paymentService,
    checkoutData,
    selectPaymentMethodAction
) {
    'use strict';

    return function (checkoutDataResolver) {
        checkoutDataResolver.resolvePaymentMethod = function () {
            var availablePaymentMethods = paymentService.getAvailablePaymentMethods();

            if (availablePaymentMethods) {
                _.each(availablePaymentMethods, function (payment) {
                    if (payment.method == "verifone_hosted") {
                        checkoutData.setSelectedPaymentMethod(payment.method);
                        selectPaymentMethodAction(payment);
                        return true;
                    }
                });
            }

            var selectedPaymentMethod = checkoutData.getSelectedPaymentMethod();

            if (!selectedPaymentMethod && availablePaymentMethods.length > 0) {
                availablePaymentMethods.some(function (payment) {
                    selectPaymentMethodAction(payment);
                    return true;
                });
            }
        };

        return checkoutDataResolver;
    };
});
