define(['uiElement', 'jquery', 'Magento_Customer/js/customer-data', 'slick'],
    function (Component, $, customerData,) {
    'use strict';

    return Component.extend({
        defaults: {
            currentProductId: null,
            websiteId: window.checkout.websiteId,
            products: [],
            limitProducts: 12,
            customer: customerData.get('customer'),
            tracks: {
                products: true,
                customer: true,
            }
        },

        initialize() {
            this._super();
            this.products = this.getProducts();
        },

        getProducts() {
            try {
                const recentlyViewedRaw = localStorage.getItem('recently_viewed_product');
                const productStorageRaw = localStorage.getItem('product_data_storage');

                if (!recentlyViewedRaw || !productStorageRaw) return [];

                const recentlyViewed = JSON.parse(recentlyViewedRaw);
                const productStorage = JSON.parse(productStorageRaw);

                return Object.values(recentlyViewed)
                    .filter(item => item.scope_id === String(this.websiteId))
                    .filter(item => item.product_id !== this.currentProductId)
                    .map(item => {
                        const productData = productStorage[item.product_id];
                        if (productData && String(productData.store_id) === String(this.websiteId)) {
                            return { ...item, ...productData };
                        }
                        return null;
                    })
                    .filter(Boolean)
                    .sort((a, b) => b.added_at - a.added_at)
                    .slice(0, this.limitProducts);

            } catch (e) {
                console.error('[Recently Viewed] Error parsing localStorage:', e);
                return [];
            }
        },

        initSlider(sliderSelector) {
            const $slider = $(sliderSelector);

            const getItemWidth = () => {
                return window.innerWidth <= 1024 ? 130 : 210;
            };

            const initialize = () => {
                if ($slider.hasClass('slick-initialized')) {
                    $slider.slick('unslick');
                }

                const itemWidth = getItemWidth();
                const containerWidth = $slider.width();
                const slideCount = $slider.children().length;
                const totalSlidesWidth = slideCount * itemWidth;
                const showArrows = totalSlidesWidth > containerWidth;
                const slidesToShow = Math.floor(containerWidth / itemWidth);

                $slider.slick({
                    dots: false,
                    infinite: false,
                    speed: 300,
                    variableWidth: true,
                    arrows: showArrows,
                    slidesToShow: slidesToShow
                });
            };

            initialize();
        }
    });
});
