define([
    'jquery',
], function($){
    return function (config, element) {

        function resetAllFilter() {
            var allFilterAttrId = [...document.querySelectorAll('.store-locator__faux-filter-container-tab-item[data-attr-id]')].map((el)=>{ return el.dataset.attrId; })
            allFilterAttrId.forEach((attrId)=>{document.body.querySelector('select[name="' + attrId + '"]').selectedIndex = 0;})
        }

        function generateCounterLabel(fauxFilterContainerTabItem) {
            var counterLabel = '(0)';
            if(fauxFilterContainerTabItem.dataset.tagSearch == 'all'){
                var counter = document.body.querySelectorAll('div.amlocator-store-desc').length;
            }
            else {
                var dataTagSearch = fauxFilterContainerTabItem.dataset.tagSearch;
                var counter = document.body.querySelectorAll('div.amlocator-store-desc[data-' + dataTagSearch + ']').length;
            }

            counterLabel = '(' + counter + ')';
            return '(' + counter + ')';
        }

        document.body.querySelector('[data-tag-search="running_expert_store"]').classList.add('active');

        var storeLocatorFauxFilterContainer = element;
        var allFauxFilterContainerTabItem = storeLocatorFauxFilterContainer.querySelectorAll('.store-locator__faux-filter-container-tab-item');
        var storeLocatorFilterButton =  document.body.querySelector('#amlocatorFilterAttributeButton');
        var storeLocatorResetButton =  document.body.querySelector('#storeLocatorResetButton');

        for(var i=0; i<allFauxFilterContainerTabItem.length; i++) {
            var fauxFilterContainerTabItem = allFauxFilterContainerTabItem[i];
            var fauxFilterContainerTabItemCounter = fauxFilterContainerTabItem.querySelector('.store-locator__faux-filter-container-tab-item__counter')

            //set counter
            fauxFilterContainerTabItemCounter.innerHTML = generateCounterLabel(fauxFilterContainerTabItem);

            //add click event
            fauxFilterContainerTabItem.addEventListener('click', function(e){
                document.body.querySelector('.store-locator__faux-filter-container-tab-item.active').classList.remove('active');
                e.currentTarget.classList.add('active');

                if(e.currentTarget.dataset.tagSearch == 'all'){
                    storeLocatorResetButton.click(); //reset
                }
                else {
                    var selectedAttrId = e.currentTarget.dataset.attrId;
                    //reset other ones
                    resetAllFilter();

                    //set selected one
                    document.body.querySelector('select[name="' + selectedAttrId + '"]').selectedIndex = 2;

                    //trigger filter
                    storeLocatorFilterButton.click();
                }
            })
        }
    }
});
