<?php
namespace Overdose\SnowdogMenu\Plugin\Model;

use Magento\Framework\Event\ManagerInterface;
use Snowdog\Menu\Api\Data\MenuInterface;
use Snowdog\Menu\Model\MenuRepository;

/**
 * Class Save
 */
class MenuRepositoryPlugin
{
    /**
     * @var ManagerInterface
     */
    protected $eventManager;

    /**
     * MenuRepositoryPlugin constructor.
     *
     * @param ManagerInterface $eventManager
     */
    public function __construct
    (
        ManagerInterface $eventManager
    ) {
        $this->eventManager = $eventManager;
    }

    /**
     * @param MenuRepository $subject
     * @param $result
     * @param MenuInterface $menu
     * @return mixed
     */
    public function afterSave(
        MenuRepository $subject,
        $result,
        MenuInterface $menu
    ) {
        if (!$menu->hasDataChanges()) {
            $menu->cleanModelCache();
            $this->eventManager->dispatch('clean_cache_by_tags', ['object' => $menu]);
        }
        return $result;
    }
}
