<?php

namespace Overdose\SnowdogMenu\Block;

use Magento\Framework\Api\Search\FilterGroupBuilder;
use Magento\Framework\Api\Search\SearchCriteriaFactory;
use Magento\Framework\View\Element\Template;
use Magento\Framework\Event\Manager as EventManager;
use Magento\Framework\Escaper;
use Snowdog\Menu\Api\MenuRepositoryInterface;
use Snowdog\Menu\Api\NodeRepositoryInterface;
use Snowdog\Menu\Model\Menu\Node\Image\File as ImageFile;
use Snowdog\Menu\Model\NodeTypeProvider;
use Snowdog\Menu\Model\TemplateResolver;
use Magento\Framework\Filesystem;
use Magento\Framework\Filesystem\DirectoryList;
use Magento\Framework\Filesystem\Io\File;
use Magento\Catalog\Helper\Output;
use Overdose\SnowdogMenu\Helper\Data;
use Exception;

class Menu extends \Snowdog\Menu\Block\Menu
{
    /**
     * @var Data
     */
    protected $dataHelper;

    private $submenuTemplate = 'Snowdog_Menu::mobile-menu/menu/sub_menu.phtml';


    /**
     * @param Template\Context $context
     * @param EventManager $eventManager
     * @param MenuRepositoryInterface $menuRepository
     * @param NodeRepositoryInterface $nodeRepository
     * @param NodeTypeProvider $nodeTypeProvider
     * @param SearchCriteriaFactory $searchCriteriaFactory
     * @param FilterGroupBuilder $filterGroupBuilder
     * @param TemplateResolver $templateResolver
     * @param ImageFile $imageFile
     * @param Escaper $escaper
     * @param Output $helperOutput
     * @param File $file
     * @param DirectoryList $dir
     * @param Filesystem $filesystem
     * @param Data $dataHelper
     * @param array $data
     */
    public function __construct
    (
        Template\Context        $context,
        EventManager            $eventManager,
        MenuRepositoryInterface $menuRepository,
        NodeRepositoryInterface $nodeRepository,
        NodeTypeProvider        $nodeTypeProvider,
        SearchCriteriaFactory   $searchCriteriaFactory,
        FilterGroupBuilder      $filterGroupBuilder,
        TemplateResolver        $templateResolver,
        ImageFile               $imageFile,
        Escaper                 $escaper,
        Output                  $helperOutput,
        File                    $file,
        DirectoryList           $dir,
        Filesystem              $filesystem,
        Data                    $dataHelper,
        array                   $data = []
    ) {
        $this->helperOutput = $helperOutput;
        $this->file = $file;
        $this->dir = $dir;
        $this->filesystem = $filesystem;
        $this->dataHelper = $dataHelper;
        parent::__construct($context, $eventManager, $menuRepository, $nodeRepository, $nodeTypeProvider, $searchCriteriaFactory, $filterGroupBuilder, $templateResolver, $imageFile, $escaper, $data);
    }

/**
 * Retrieve Top level menu html(only first level) &&
 * write Full menu html to file menu.html
 *
 *
 */
    public function getAjaxMenuHtml()
    {
        $nodes = $this->getNodes();
        $html = '';
        $topLevelMenu ='';
        foreach ($nodes as $node) {
            $childrenLevel = $node->getLevel() + 1;
            $children = $this->getNodes($childrenLevel, $node);
            $node->setIsParent((bool) $children);

            $additionalClasses = $node->getClasses() ? ' ' . $node->getClasses() : '';
            $itemClasses = $additionalClasses;

            if($children) {
                $html .='<li class="mobile-menu__item'.$itemClasses.' mobile-menu__parent">';
                $html .= $this->renderMenuNode($node);
                $html .= $this->renderSubmenu($children, $node, $childrenLevel);
                $html .='</li>';

                $topLevelMenu .='<li class="mobile-menu__item'.$itemClasses.' mobile-menu__parent">';
                $topLevelMenu .= $this->renderMenuNode($node);
                $topLevelMenu .='</li>';
            }else{
                $html .='<li class="mobile-menu__item'.$itemClasses.'">';
                $html .= $this->renderMenuNode($node);
                $html .='</li>';

                $topLevelMenu .='<li class="mobile-menu__item'.$itemClasses.'">';
                $topLevelMenu .= $this->renderMenuNode($node);
                $topLevelMenu .='</li>';
            }
        }

        $menuDir = $this->dir->getPath(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA) .
            $this->dataHelper->getPathWriteMenuInPub();

        if (!file_exists($menuDir . '/mobile_menu.html')) {
            // create menu file.
            $this->file->mkdir($menuDir);
            $dirToWrite = $this->filesystem->getDirectoryWrite(
                \Magento\Framework\App\Filesystem\DirectoryList::MEDIA
            );
            $dirToWrite->writeFile(
                $this->dataHelper->getPathWriteMenuInPub() . '/mobile_menu.html',
                $html,
                'w+'
            );
        }
        return $topLevelMenu;
    }

    /**
     * @param NodeRepositoryInterface $node
     * @return string
     */
    public function renderMenuNode($node)
    {
        if ($this->getData('render_in_admin')) {
            $result = $this->getMenuNodeBlock($node);
            $result->setData('area', 'frontend');
            return $result->toHtml();
        }
        return parent::renderMenuNode($node);
    }

    /**
     * @param NodeRepositoryInterface $node
     * @return Template
     */
    private function getMenuNodeBlock($node)
    {
        $nodeBlock = $this->getNodeTypeProvider($node->getType());
        $level = $node->getLevel();
        $isRoot = 0 == $level;
        $nodeBlock->setId($node->getNodeId())
            ->setTitle($node->getTitle())
            ->setLevel($level)
            ->setIsRoot($isRoot)
            ->setIsParent((bool) $node->getIsParent())
            ->setIsViewAllLink(false)
            ->setContent($node->getContent())
            ->setNodeClasses($node->getClasses())
            ->setMenuClass($this->getMenu()->getCssClass())
            ->setMenuCode($this->getData('menu'))
            ->setTarget($node->getTarget());

        return $nodeBlock;
    }

    /**
     * @param array $nodes
     * @param NodeRepositoryInterface $parentNode
     * @param int $level
     * @return string
     */
    public function renderSubmenu($nodes, $parentNode, $level = 0)
    {
        if ($this->getData('render_in_admin')) {
            $this->setData('area', 'frontend');
            if ($nodes) {
                return $this->getSubmenuBlock($nodes, $parentNode, $level)->toHtml();
            }
            return '';
        }
        return parent::renderSubmenu($nodes, $parentNode, $level);
    }

    /**
     * @param array $nodes
     * @param NodeRepositoryInterface $parentNode
     * @param int $level
     * @return \Snowdog\Menu\Block\Menu
     */
    private function getSubmenuBlock($nodes, $parentNode, $level = 0)
    {
        $block = clone $this;
        $block->setSubmenuNodes($nodes)
            ->setParentNode($parentNode)
            ->setLevel($level);
        $block->setTemplateContext($block);
        $block->setTemplate($this->submenuTemplate);

        return $block;
    }

    /**

     * Returns url for menu.html file

     *

     * @return string

     * @throws \Magento\Framework\Exception\NoSuchEntityException

     */

    public function getMenuFileUrl($file_name){

        $mediaUrl = rtrim($this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA), '/');

        return $mediaUrl . $this->dataHelper->getPathWriteMenuInPub() . '/' .$file_name;

    }

    /**
     * @param $parentNode
     * @return string
     */
    public function getBackTitle($parentNode): string
    {
        try {
            $targetId = (int)$parentNode->getNodeId();
            $tree = $this->getNodesTree();
            $path = [];
            if ($this->findNodePath($tree, $targetId, $path)) {
                if (count($path) >= 2) {
                    $prevNode = $path[count($path) - 2];
                    return (string)$prevNode->getTitle();
                }
                return (string)$parentNode->getTitle();
            }
            return (string)$parentNode->getTitle();
        } catch (Exception $e) {
            return '';
        }
    }

    /**
     * @param array $items
     * @param int $targetId
     * @param array $path
     * @return bool
     */
    private function findNodePath(array $items, int $targetId, array &$path): bool
    {
        foreach ($items as $item) {
            $node = $item['node'];
            $path[] = $node;
            if ((int)$node->getNodeId() === $targetId) {
                return true;
            }
            if (!empty($item['children']) && $this->findNodePath($item['children'], $targetId, $path)) {
                return true;
            }
            array_pop($path);
        }
        return false;
    }
}
