<?php

namespace Overdose\ShoeFinder\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Find
 * @package Overdose\ShoeFinder\Controller\Index
 */
class Find extends Action
{
    /**
     * @var JsonFactory
     */
    protected $jsonFactory;

    /**
     * Find constructor.
     * @param Context $context
     * @param JsonFactory $jsonFactory
     */
    public function __construct(
        Context $context,
        JsonFactory $jsonFactory
    )
    {
        $this->jsonFactory = $jsonFactory;

        parent::__construct($context);
    }

    public function execute()
    {
        $data = json_decode($this->getRequest()->getParam('data'), true);
        
        if ($data[2] === 'trail') {
            $category = 'trail-running-shoes';
        } else {
            $category = $data[3];
        }

        // Build SearchSpring filter format URL
        $baseUrl = $this->_url->getUrl($data[1] . '/shoes/' . $category);
        $filters = [];
        
        // Add asics_pronation filter (data[4])
        if (isset($data['4'])) {
            $filters[] = 'filter:asics_pronation:' . $data['4'];
        }
        
        // Add asics_cushion filter (data[5])
        if (isset($data['5'])) {
            $filters[] = 'filter:asics_cushion:' . $data['5'];
        }

        
        // Construct the final URL with SearchSpring filter format
        if (!empty($filters)) {
            $result = $baseUrl . '#/' . implode('/', $filters);
        } else {
            $result = $baseUrl;
        }

        return $this->jsonFactory->create()->setData($result);
    }
}
