<?php
namespace Overdose\Sales\Block\Order;

use Magento\Framework\Registry;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use Magento\Framework\View\Element\Template\Context as TemplateContext;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Sales\Model\Order\Address\Renderer as AddressRenderer;

/**
 * Class Info
 * @package Overdose\Sales\Block\Order
 */
class Info extends \Magento\Sales\Block\Order\Info
{
    /**
     * Use eShipping for tracing
     */
    const TRACKING_URL = 'https://www.nzpost.co.nz/tools/tracking/item/';

    /**
     * @var TimezoneInterface
     */
    protected $timezone;

    /**
     * Info constructor.
     * @param TemplateContext $context
     * @param Registry $registry
     * @param PaymentHelper $paymentHelper
     * @param AddressRenderer $addressRenderer
     * @param array $data
     * @param TimezoneInterface $timezone
     */
    public function __construct(
        TemplateContext $context,
        Registry $registry,
        PaymentHelper $paymentHelper,
        AddressRenderer $addressRenderer,
        TimezoneInterface $timezone,
        array $data = []
    ) {
        parent::__construct($context, $registry, $paymentHelper, $addressRenderer, $data);
        $this->timezone = $timezone;
    }

    /**
     * Get tracking numbers
     *
     * @return array
     */
    public function getOrderTracking()
    {
        $trackingNumbers = [];
        try {
            /** @var Magento\Sales\Model\Order $order */
            $order = $this->getOrder();
            /** @var Magento\Sales\Model\ResourceModel\Order\Shipment\Collection $shipmentCollections */
            $shipmentCollections = $order->getShipmentsCollection();
            foreach ($shipmentCollections as $shipmentCollection) {
                /** @var array $tracks */
                $tracks = $shipmentCollection->getAllTracks();
                foreach ($tracks as $tracking) {
                    $trackingNumber = $tracking->getTrackNumber();
                    if ($trackingNumber) {
                        $trackingNumbers[] = self::TRACKING_URL . $trackingNumber;
                    }
                }
            }
        } catch (\Exception $e) {
        }

        return $trackingNumbers;
    }

    /**
     * Get order Shipped Date
     */
    public function getOrderShippedDate()
    {
        $date = null;
        try {
            /** @var Magento\Sales\Model\Order $order */
            $order = $this->getOrder();
            /** @var Magento\Sales\Model\ResourceModel\Order\Shipment\Collection $shipmentCollections */
            $shipmentCollections = $order->getShipmentsCollection();
            foreach ($shipmentCollections as $shipmentCollection) {
                $createdDate = $shipmentCollection->getCreatedAt();
                $date = $this->timezone->date($createdDate)->format('d/m/y');
            }
        } catch (\Exception $e) {
        }

        return $date;
    }

    /**
     * @return array
     */
    public function getPaymentMethod()
    {
        $method = null;
        try {
            /** @var Magento\Sales\Model\Order $order */
            $order = $this->getOrder();
            $method = $order->getPayment()->getMethodInstance()->getTitle();
            // $method = $order->getPayment()->getAdditionalInformation()['method_title'];
        } catch (\Exception $e) {
        }

        return $method;
    }
}
