<?php
namespace Overdose\ProductBanners\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\App\RequestInterface;
use Overdose\ProductBanners\Helper\Data;
use Overdose\ProductBanners\Model\Product\Type\Banner;

/**
 * Class CollectionLoad
 * @package Overdose\ProductBanners\Observer
 */
class CollectionLoad implements ObserverInterface
{
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var Data
     */
    private $helperData;

    /**
     * CollectionLoad constructor.
     * @param RequestInterface $request
     * @param Data $helperData
     */
    public function __construct(
        RequestInterface $request,
        Data $helperData
    ) {
        $this->request = $request;
        $this->helperData = $helperData;
    }

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer)
    {
        $requestObj = $this->request;
        $count = count($requestObj->getParams());
        if ($requestObj->getFullActionName() == 'catalog_category_view' && $count > 1) {
            $collection = $observer->getData('collection');
            $isSensitiveFilter = $this->helperData->isFilterSensitive();
            if (!$isSensitiveFilter) { //banner always appear
                $collection->getSelect()
                    ->orWhere('(e.type_id = ?)', Banner::PRODUCT_TYPE_BANNER);
            }
        }
    }
}
