<?php

namespace Overdose\NotificationBar\ViewModel;

use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class NotificationBar implements ArgumentInterface
{
    const ENABLED = 'notification_bar/general/notification_enabled';
    const COLOR = 'notification_bar/general/color';
    const CONTENT = 'notification_bar/general/content';

    /**
     * @var ScopeConfigInterface
     */
    private $config;

    /**
     * NotificationBar constructor.
     * @param ScopeConfigInterface $config
     */
    public function __construct(
        ScopeConfigInterface $config
    ) {
        $this->config = $config;
    }

    /**
     * @return bool
     */
    public function getEnabled()
    {
        return $this->config->isSetFlag(self::COLOR, ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return mixed
     */
    public function getColor()
    {
        return $this->config->getValue(self::COLOR, ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return mixed
     */
    public function getContent()
    {
        return $this->config->getValue(self::CONTENT, ScopeInterface::SCOPE_STORE);
    }
}
