<?php

namespace Overdose\InventoryShipping\Model\ResourceModel\OrderSource;

use Magento\Framework\App\ResourceConnection;

/**
 * Get order source codes by order Id
 */
class GetOrderSourceCodesByOrderId
{
    /**
     * Constant for fields in data array
     */
    const ORDER_ID    = 'order_id';
    const SOURCE_CODE = 'source_code';
    const SKU         = 'sku';
    const QUANTITY    = 'quantity';

    /**
     * @var ResourceConnection
     */
    private ResourceConnection $resourceConnection;

    /**
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(ResourceConnection $resourceConnection)
    {
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * Get source codes by order Id
     *
     * @param int $orderId
     * @return array
     */
    public function execute(int $orderId): array
    {
        $connection = $this->resourceConnection->getConnection();
        $tableName = $this->resourceConnection
            ->getTableName('inventory_order_source');

        $select = $connection->select()
            ->from($tableName, [
                self::SKU         => self::SKU,
                self::SOURCE_CODE => self::SOURCE_CODE,
                self::QUANTITY    => self::QUANTITY
            ])
            ->where(self::ORDER_ID . ' = ?', $orderId);

        $result = [];
        foreach ($connection->fetchAll($select) as $row) {
            $result[$row[self::SKU]][] = [
                'sourceCode' => $row[self::SOURCE_CODE],
                self::QUANTITY    => $row[self::QUANTITY]
            ];
        }
        return $result;
    }
}
