<?php

declare(strict_types=1);

namespace Overdose\InventoryShipping\Model\ResourceModel;

use Magento\Framework\App\ResourceConnection;
use Magento\InventoryShippingAdminUi\Model\ResourceModel\GetAllocatedSourcesForOrder as DefaultGetAllocatedSourcesForOrder;
use Overdose\InventoryShipping\Helper\OrderSource;

/**
 * Get allocated sources for specified order.
 */
class GetAllocatedSourcesForOrder extends DefaultGetAllocatedSourcesForOrder
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;
    private OrderSource $orderSource;

    /**
     * @param ResourceConnection $resourceConnection
     * @param OrderSource $orderSource
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        OrderSource $orderSource
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->orderSource = $orderSource;
        parent::__construct($resourceConnection);
    }

    /**
     * Get allocated sources by order ID
     *
     * @param int $orderId
     * @return array
     */
    public function execute(int $orderId): array
    {
        return $this->orderSource->getOrderSourceCodesByOrderId($orderId);
    }
}
