<?php

namespace Overdose\InStorePickup\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    const XML_PATH_ACTIVE = 'in_store_pickup/stock_availability/active';
    const XML_PATH_OUTOFSTOCK = 'in_store_pickup/stock_availability/outofstock';
    const XML_PATH_MODEL_CONTENT = 'in_store_pickup/stock_availability/modal_content';

    /**
     * @param $storeId
     * @return mixed
     */
    public function isActive($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_ACTIVE, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function getModelContent($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_MODEL_CONTENT, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * @param $storeId
     * @return mixed
     */
    public function showOutofstock($storeId = null)
    {
        return $this->scopeConfig->getValue(self::XML_PATH_OUTOFSTOCK, ScopeInterface::SCOPE_STORE, $storeId);
    }
}
