<?php

namespace Overdose\DataLayer\Plugin;

use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\App\Response\RedirectInterface;
use Overdose\DataLayer\Helper\Cookies;
use Magento\Checkout\Model\Session;

class AddressUpdate extends GenericPlugin
{
    /**
     * @var Session
     */
    protected CustomerSession $customerSession;

    /**
     * @param Cookies $cookiesHelper
     * @param RedirectInterface $redirect
     * @param Session $session
     * @param CustomerSession $customerSession
     */
    public function __construct
    (
        Cookies           $cookiesHelper,
        RedirectInterface $redirect,
        Session           $session,
        CustomerSession   $customerSession
    ) {
        $this->customerSession = $customerSession;
        parent::__construct($cookiesHelper, $redirect, $session);
    }

    /**
     * @param $subject
     * @param $result
     * @return mixed
     */
    public function afterExecute($subject, $result)
    {
        try {
            $customerEmail = $this->customerSession->getCustomer()->getEmail();
            if ($customerEmail) {
                $customerEmail = strtolower($customerEmail);
                $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail);
            }
        } catch (\Exception $e) {
        }

        return $result;
    }
}
