<?php

namespace Overdose\DataLayer\Observer;

use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Event\ObserverInterface;
use Overdose\DataLayer\Helper\Ec;
use Magento\Checkout\Model\Session;

class Checkout implements ObserverInterface
{
    /**
     * @var Ec
     */
    protected $ec;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var CustomerSession
     */
    protected $customerSession;

    /**
     * @param Ec $ec
     * @param Session $checkoutSession
     * @param CustomerSession $customerSession
     */
    public function __construct
    (
        Ec $ec,
        Session $checkoutSession,
        CustomerSession $customerSession
    ) {
        $this->ec = $ec;
        $this->checkoutSession = $checkoutSession;
        $this->customerSession = $customerSession;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $quote = $this->checkoutSession->getQuote();
            $totalDiscount = 0;
            $quoteItemsDiscountMapping = [];
            if ($quote && $quote->getCouponCode()) {
                $couponCode = $quote->getCouponCode();
                $quoteItems = $quote->getAllVisibleItems();
                foreach ($quoteItems as $quoteItem) {
                    $quoteItemsDiscountMapping[$quoteItem->getSku()] = (float)$quoteItem->getDiscountAmount();
                    $totalDiscount = (float)($totalDiscount + $quoteItemsDiscountMapping[$quoteItem->getSku()]);
                }
            } else {
                $couponCode = null;
            }
            $customData = [];
            $customItemsData = [];
            $transport = $observer->getData('transport');
            $checkoutData = $transport->getData('checkout');
            $ecommerceData = $checkoutData['payload'];
            if (isset($ecommerceData['ecommerce']) && $ecommerceData['ecommerce']) {
                $customData['currency'] = $ecommerceData['currency'];
                $customData['value'] = $ecommerceData['value'];
                if (isset($ecommerceData['ecommerce']['items']) && count($ecommerceData['ecommerce']['items'])) {
                    foreach ($ecommerceData['ecommerce']['items'] as $item) {
                        $customItemData = [];
                        $customItemData['item_id'] = $item['item_id'];
                        $customItemData['item_name'] = $item['item_name'];
                        $product = $this->ec->getProductBySku($customItemData['item_id']);
                        if ($product) {
                            $customItemData['affiliation'] = $this->ec->getAffiliation($product);
                            $customItemData['item_brand'] = $this->ec->getAffiliation($product);
                            $customItemData['item_variant'] = $this->ec->getProductColor($product);
                            $itemWidth = $this->ec->getProductWidth($product);
                            if ($itemWidth) {
                                $customItemData['item_width'] = $itemWidth;
                            }
                            $odAddToCartSession = $this->customerSession->getOdAddToCartSession();
                            $customItemData['item_list_id'] = $this->ec->getSessionItemListId($odAddToCartSession, $product);
                            $customItemData['item_list_name'] = $this->ec->getSessionItemListName($odAddToCartSession, $product);
                            $customItemData['price'] = $item['price'];
                            $customItemData['quantity'] = $item['quantity'];
                            if ($couponCode) {
                                $customItemData['coupon'] = $couponCode;
                            }
                            $childProduct = $this->ec->getProductBySku($item['variant_id']);
                            if ($childProduct && $childProduct->getId()) {
                                $size = $this->ec->getSize($childProduct);
                                if ($size) {
                                    $customItemData['item_size'] = $size;
                                }
                                if (isset($quoteItemsDiscountMapping[$childProduct->getSku()])) {
                                    $customItemData['discount'] = $quoteItemsDiscountMapping[$childProduct->getSku()];
                                }
                            } else {
                                if ($totalDiscount) {
                                    $customItemData['discount'] = $totalDiscount;
                                }
                            }
                            $categoryData = $this->ec->getCategoryData($product);
                            $customItemData = array_merge($customItemData, $categoryData);
                        }
                        $customItemsData[] = $customItemData;
                    }
                }
                $customData['items'] = $customItemsData;
                $ecommerceData['ecommerce'] = $customData;
                $checkoutData['payload'] = $ecommerceData;

                $transport->setData('checkout', $checkoutData);
            }
        } catch (\Exception $e) {
        }

        return $this;
    }
}
