<?php

namespace Overdose\Customer\ViewModel;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Sales\Model\Order\Config;
use Magento\Sales\Model\OrderFactory;
use Magento\Store\Model\ScopeInterface;
use Magento\Wishlist\Model\Wishlist;

/**
 * Class Statistic
 * @package Overdose\Customer\ViewModel
 */
class Statistic implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var OrderFactory
     */
    private $orderFactory;

    /**
     * @var Wishlist
     */
    private $wishlist;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    /**
     * List of orders
     * @var array
     */
    private $orders;
    /**
     * @var Config
     */
    private $orderConfig;

    /**
     * Statistic constructor.
     * @param Session $session
     * @param ScopeConfigInterface $scopeConfig
     * @param SerializerInterface $serializer
     * @param OrderFactory $orderFactory
     * @param Wishlist $wishlist
     * @param RequestInterface $request
     * @param ProductRepositoryInterface $productRepository
     * @param Config $orderConfig
     */
    public function __construct(
        Session $session,
        ScopeConfigInterface $scopeConfig,
        SerializerInterface $serializer,
        OrderFactory $orderFactory,
        Wishlist $wishlist,
        RequestInterface $request,
        ProductRepositoryInterface $productRepository,
        Config $orderConfig
    ) {
        $this->session = $session;
        $this->scopeConfig = $scopeConfig;
        $this->serializer = $serializer;
        $this->orderFactory = $orderFactory;
        $this->wishlist = $wishlist;
        $this->request = $request;
        $this->productRepository = $productRepository;
        $this->orderConfig = $orderConfig;
    }


    /**
     * @return string
     */
    public function getLabel()
    {
        $count = count($this->getOrders());
        return "My Orders <span class=\"items-amount\">" . $count . "</span>";
    }


    /**
     * @return string
     */
    public function getOrderCount()
    {
        return count($this->getOrders());
    }

    /**
     * @return string
     */
    public function getWishListLabel()
    {
        $count = count($this->getWishlist());
        return "My Favourites <span class=\"items-amount\">" . $count . "</span>";
    }


    /**
     * @return string
     */
    public function getWishListCount()
    {
        return count($this->getWishlist());
    }

    /**
     * Get customer orders
     *
     * @return array|\Magento\Sales\Model\ResourceModel\Order\Collection
     */
    public function getOrders()
    {
        if (!($customerId = $this->session->getCustomerId())) {
            return [];
        }
        if (!$this->orders) {
            $this->orders = $this->orderFactory->create()->getCollection()->addFieldToSelect(
                '*'
            )->addFieldToFilter(
                'customer_id',
                $customerId
            )->addFieldToFilter(
                'status',
                ['in' => $this->orderConfig->getVisibleOnFrontStatuses()]
            )->setOrder(
                'created_at',
                'desc'
            );
        }
        return $this->orders;
    }

    /**
     * @return \Magento\Wishlist\Model\ResourceModel\Item\Collection
     */
    public function getWishlist()
    {
        $id = $this->session->getCustomer()->getId();
        $wishlist = $this->wishlist->loadByCustomerId($id)->getItemCollection();

        return $wishlist;
    }

    /**
     * @return string
     */
    public function getReorderLabel()
    {
        return "Reorder";
    }

}
