<?php
namespace Overdose\Customer\Console\Command;

use Magento\Customer\Model\ResourceModel\Customer\CollectionFactory;
use Magento\Framework\App\State;
use Overdose\Customer\Model\SendCreatePassword;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class MassSendResetPasswordLink
 * @package Overdose\Customer\Console\Command
 */
class MassSendResetPasswordLink extends Command
{
    /**
     * @var State
     */
    private $state;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @var SendCreatePassword
     */
    private $sendCreatePassword;

    /**
     * MassSendResetPasswordLink constructor.
     * @param State $state
     * @param CollectionFactory $collectionFactory
     * @param SendCreatePassword $sendCreatePassword
     */
    public function __construct(
        State $state,
        CollectionFactory $collectionFactory,
        SendCreatePassword $sendCreatePassword
    ) {
        parent::__construct();
        $this->state = $state;
        $this->collectionFactory = $collectionFactory;
        $this->sendCreatePassword = $sendCreatePassword;
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('overdose:customer:mass-send-reset-password-link')
            ->setDescription('WARNING: Do not run this command if you dont know what you are doing. IMPORTANT: Make sure to disable password protection from Configuration -> Customers -> Customer Configuration -> Password Options -> Password Reset Protection Type and re-anable it after this process');
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
        } catch (\Exception $e) {
            // do nothing
        }
        $start = microtime(true);
        $output->writeln("<info>Start mass send reset password link process</info>");

        $output->writeln("<info>" . $this->massExecute($output) . "</info>");

        $end = microtime(true);
        $diff = round($end - $start, 2);
        $output->writeln("<info>Mass send reset password link process completed in $diff seconds.</info>");
    }

    /**
     * @param $output
     */
    protected function massExecute($output)
    {
        $customerCollection = $this->collectionFactory->create();
        $customerCollection->addFieldToFilter('password_hash', ['null'=>true]);

        if ($customerCollection) {
            try {
                $i = 1;
                foreach ($customerCollection as $customer) {
                    $email = $customer->getEmail();
                    if ($email) {
                        $results = $this->sendCreatePassword->initiatePasswordCreate($email);
                        if ($results) {
                            $output->writeln("<info>" . $i . " " . $email . " Mail sent" . "</info>");
                        } else {
                            $output->writeln("<info>Error sending email to " . $email . "</info>");
                        }

                        $i++;
                    }
                }
            } catch (\Exception $exception) {
                $output->writeln("<info>" . $email . " -> " . $exception->getMessage() . "</info>");
            }
        }
    }
}
