<?php
namespace Overdose\Customer\Console\Command;

use Magento\Framework\App\State;
use Magento\Newsletter\Model\SubscriberFactory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class MassNewsletterSubscription
 * @package Overdose\Customer\Console\Command
 */
class MassNewsletterSubscription extends Command
{
    /**
     * @var State
     */
    private $state;
    /**
     * @var SubscriberFactory
     */
    private $subscriberFactory;
    /**
     * @var \Magento\Customer\Api\CustomerRepositoryInterface
     */
    private $customerRepository;

    /**
     * MassNewsletterSubscription constructor.
     * @param State $state
     * @param SubscriberFactory $subscriberFactory
     * @param \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository
     */
    public function __construct(
        State $state,
        SubscriberFactory $subscriberFactory,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository
    ) {
        parent::__construct();
        $this->state = $state;
        $this->subscriberFactory = $subscriberFactory;
        $this->customerRepository = $customerRepository;
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this->setName('overdose:customer:mass-newsletter-subscription')
            ->setDescription('WARNING: Do not run this command if you dont know what you are doing.');
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        try {
            $this->state->setAreaCode(\Magento\Framework\App\Area::AREA_FRONTEND);
        } catch (\Exception $e) {
            // do nothing
        }
        $start = microtime(true);
        $output->writeln("<info>Start mass process</info>");

        $output->writeln("<info>" . $this->massExecute($output) . "</info>");

        $end = microtime(true);
        $diff = round($end - $start, 2);
        $output->writeln("<info>Mass process completed in $diff seconds.</info>");
    }

    /**
     * @param $output
     */
    protected function massExecute($output)
    {
        // // $file = '/home/lionff/www/customer_csv_newsletter_import.csv';
        // //$file = '/Users/hansaka/Documents/LIONP_RODUCT_IMPORT/ff_customer_import.csv';
        // $websiteId = 1;
        // if (($handle = fopen($file, "r")) !== false) {
        //     while (($data = fgetcsv($handle, 10000, ",")) !== false) {
        //         $email = $data[0];
        //         $subs = $data[1];
        //         if ($subs=='Y') {
        //             try {
        //                 $customer = $this->customerRepository->get($email, $websiteId);
        //                 if ($customer->getId()) {
        //                     $_subscriberFactory = $this->subscriberFactory->create();
        //                     $_subscriberFactory->subscribeCustomerById($customer->getId());
        //                     $output->writeln($customer->getId() . ") " . $email . " Added to newsletter subscribe\n");
        //                 }
        //             } catch (\Exception $exception) {
        //             }
        //         }
        //     }
        //     fclose($handle);
        // }
    }
}
