<?php

namespace Overdose\Customer\Block\Form;

use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\Customer;
use Magento\Customer\Model\CustomerFactory;
use Magento\Customer\Model\Session;
use Magento\Eav\Model\ConfigFactory;
use Magento\Framework\View\Element\Template\Context;
use Magento\Newsletter\Model\SubscriberFactory;

class Edit extends \Magento\Customer\Block\Form\Edit
{
    protected $eavAttributeFactory;

    protected  $customerFactory;

    public function __construct(
        Context $context,
        Session $customerSession,
        SubscriberFactory $subscriberFactory,
        CustomerRepositoryInterface $customerRepository,
        AccountManagementInterface $customerAccountManagement,
        ConfigFactory $eavAttributeFactory,
        CustomerFactory $customerFactory,
        array $data = []
    ) {
        $this->eavAttributeFactory = $eavAttributeFactory;
        $this->customerFactory = $customerFactory;

        parent::__construct(
            $context,
            $customerSession,
            $subscriberFactory,
            $customerRepository,
            $customerAccountManagement,
            $data
        );
    }

    public function getAttributeOptions($attributeCode)
    {
        $options = $this->eavAttributeFactory->create()->getAttribute(Customer::ENTITY, $attributeCode)
            ->getSource()->getAllOptions();
        return $options;
    }

    public function getCurrentCustomer($customerId = null)
    {
        if (! $customerId) {
            $customerId = $this->getCustomer()->getId();
        }

        return $this->customerFactory->create()->load($customerId);
    }
}
