<?php declare(strict_types=1);

namespace Overdose\Customer\Block\Customer;

use Magento\Framework\View\Element\Template;
use Magento\Framework\App\Http\Context;
use Magento\Customer\Model\Context as ModelContext;

class Status extends Template
{
    /**
     * @var Context
     */
    protected Context $httpContext;

    /**
     * @param Template\Context $context
     * @param Context $httpContext
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        Context          $httpContext,
        array            $data = []
    ) {
        $this->httpContext = $httpContext;
        parent::__construct($context, $data);
    }

    /**
     * @return bool
     */
    public function getCustomerIsLoggedIn()
    {
        return (bool)$this->httpContext->getValue(ModelContext::CONTEXT_AUTH);
    }
}