<?php
declare(strict_types=1);

namespace Overdose\CustomCMSContent\Helper;

use Magento\Cms\Model\Page;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Phrase;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class CmsContentData extends AbstractHelper
{
    /**
     * Config path to 'Translate Title' header settings
     */
    private const XML_PATH_HEADER_TRANSLATE_TITLE = 'design/header/translate_title';

    /**
     * @var Page
     */
    protected $_page;

    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * CmsContentData constructor.
     *
     * @param Context $context
     * @param Page $page
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        Page $page,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct($context);
        $this->_page = $page;
        $this->_storeManager = $storeManager;
    }

    /**
     * @return bool
     */
    public function isCMSPage()
    {
        return $this->_request->getFullActionName() == 'cms_page_view';
    }

    /**
     * @return Phrase|string
     * @throws NoSuchEntityException
     */
    public function getPageHeading()
    {
        $pageId = $this->_request->getParam('page_id') ?? $this->_request->getParam('id');
        if (!$pageId) {
            return '';
        } else {
            $page = $this->_page->setStoreId($this->_storeManager->getStore()->getId())->load($pageId);
            $contentHeading = $page->getContentHeading() ?? '';
            return $this->shouldTranslateTitle() ? __($contentHeading) : $contentHeading;
        }
    }

    /**
     * Check if page title should be translated
     *
     * @return bool
     */
    private function shouldTranslateTitle(): bool
    {
        return $this->scopeConfig->isSetFlag(
            self::XML_PATH_HEADER_TRANSLATE_TITLE,
            ScopeInterface::SCOPE_STORE
        );
    }
}
