<?php
namespace Overdose\CheckoutInputPlaceholder\Plugin\Checkout\Block\Checkout\AttributeMerger;

class Plugin
{
  public function afterMerge(\Magento\Checkout\Block\Checkout\AttributeMerger $subject, $result)
  {
    if (array_key_exists('firstname', $result)) {
        $result['firstname']['placeholder'] = __('First Name');
    }

    if (array_key_exists('lastname', $result)) {
        $result['lastname']['placeholder'] = __('Last Name');
    }

    if (array_key_exists('company', $result)) {
        $result['company']['placeholder'] = __('Company Name (Optional)');
    }

    if (array_key_exists('street', $result)) {
        $result['street']['children'][0]['placeholder'] = __('Start typing your address');
        $result['street']['children'][1]['placeholder'] = __('Street Address: Line 2');
        $result['street']['children'][2]['placeholder'] = __('Street Address: Line 3');
        $result['street']['children'][3]['placeholder'] = __('Street Address: Line 4');
    }

    if (array_key_exists('city', $result)) {
        $result['city']['placeholder'] = __('City');
    }

    if (array_key_exists('building', $result)) {
        $result['building']['placeholder'] = __('Building (Optional)');
    }

    if (array_key_exists('telephone', $result)) {
        $result['telephone']['placeholder'] = __('Phone Number');
    }

    if (array_key_exists('suburb', $result)) {
        $result['suburb']['placeholder'] = __('Suburb');
    }

    if (array_key_exists('postcode', $result)) {
        $result['postcode']['placeholder'] = __('Post Code');
    }

    return $result;
  }
}
