<?php

namespace Overdose\AddressValidation\Helper;
use Laminas\Http\Request;
use Magento\Framework\App\Request\Http;
use Magento\Framework\HTTP\LaminasClientFactory;

/**
 * Property of NZMUSCLE Ltd.
 *
 * @author      Tom Lin <tom@overdose.digital>
 * @package     Overdose_AddressValidation
 * @copyright   Copyright (c) 2018 NZMUSCLE Ltd.
 */
class Nzpost extends \Magento\Framework\App\Helper\AbstractHelper
{
  protected $_helper;
  protected $_suggestData = null;
  protected $_httpClientFactory;
  protected $_accessToken;
  public function __construct(\Magento\Framework\App\Helper\Context $context,
      \Overdose\AddressValidation\Helper\Data $helper,
      LaminasClientFactory $httpClientFactory
  ) {
      $this->_helper = $helper;
      $this->_httpClientFactory = $httpClientFactory;
      $this->_accessToken = $this->getAccessToken();
      parent::__construct($context);
  }

    /**
     * Get Access token*
     *
     * @param String $uri The API call URI
     * @return access token if verify successful, otherwise return null
     */
    public function getAccessToken() {
        $httpClient =  $this->_httpClientFactory->create();
        $accessToken = null;
        $this->_helper->log("+++++++Get Access Token+++++++");
        try {
            /* @var $response Zend_Http_Response */
            $tokenUrl = "https://oauth.nzpost.co.nz/as/token.oauth2";
            $grantType = 'client_credentials';
            if($this->_helper->getTokenUrl()) {
              $tokenUrl = $this->_helper->getTokenUrl(); // "https://oauth.nzpost.co.nz/as/token.oauth2";
            }
            if($this->_helper->getGrantType()) {
              $grantType = $this->_helper->getGrantType();
            }
            $clientId = $this->_helper->getClientId();
            $clientSecret = $this->_helper->getClientSecret();
            if($clientId && $clientSecret) {
              $httpClient->setUri($tokenUrl);
              $requestData = array(
                'grant_type' => $grantType,
                'client_id' => $clientId,
                'client_secret' => $clientSecret
              );
              $httpClient->setParameterPost($requestData);
              $httpClient->setHeaders(['Content-Type' => 'application/x-www-form-urlencoded']);
              $this->_helper->log("Token request Object:");
              $this->_helper->log($requestData);
              $httpClient->setMethod(Request::METHOD_POST)->send();
              $response = $httpClient->getResponse()->getBody();

              if($response) {
                 $response = json_decode($response);
                 $accessToken = $response->access_token;
                 if($accessToken) {
                    $this->_helper->log("Get Access Token successful:");
                    $this->_helper->log($accessToken);
                 }
              } else {
                  //Log URL and API response
                  $this->_helper->log('Empty Response object');
              }
            } else {
               $this->_helper->log('Client Id= ' . $clientId . '  clientSecret= ' . $clientSecret , 'Client Id or secret is not set. More detail:');
            }
        } catch (\Throwable $ex) {
            $this->_helper->log($ex);
        }
       return $accessToken;
    }
}
