<?php

namespace BrittainWynyard\Searchspring\Controller\SuperStyle;

use BrittainWynyard\Searchspring\Model\SearchSpringStyles;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Catalog\Helper\Image;

class Fetch extends Action
{

    public function __construct(
        Context                             $context,
        private readonly JsonFactory        $resultJsonFactory,
        private readonly SearchSpringStyles $searchStyles,
        private readonly Image $imageHelper,
    )
    {
        parent::__construct($context);
    }

    public function execute(): Json|ResultInterface|ResponseInterface
    {
        $styleID = $this->getRequest()->getParam('style_id');
        $styleIds = explode(',', $styleID);
        $productCollection = $this->searchStyles->getProducts($styleIds);
        $productCollection->addUrlRewrite();
        $data = [];
        foreach ($productCollection as $index => $product) {
            $imgURL = $this->imageHelper->init($product, 'product_base_image')->getUrl();
            $data[$product->getSuperStyleId()][] = [
                'index' => $index,
                'name' => $product->getName(),
                'sku' => $product->getSku(),
                'image' => $imgURL,
                'url_key' => $product->getProductUrl(),
                'entity_id' => $product->getEntityId(),
            ];
        }

        $result = $this->resultJsonFactory->create();
        return $result->setData($data);
    }
}
