<?php

namespace BrittainWynyard\Sales\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\SalesRule\Model\Rule\CustomerFactory;
use Magento\SalesRule\Model\Coupon;
use Magento\SalesRule\Model\ResourceModel\Coupon\Usage;
class OrderCancelAfter implements ObserverInterface
{

    /** @var RequestInterface */
    private $ruleCustomerFactory;
    private $couponUsage;
    /**
     * @var Coupon
     */
    private $coupon;
    private $logger;

    public function __construct(CustomerFactory $ruleCustomer, Usage $couponUsage,  Coupon $coupon,     \Psr\Log\LoggerInterface $logger)
    {
        $this->ruleCustomerFactory = $ruleCustomer;
        $this->couponUsage = $couponUsage;
        $this->coupon = $coupon;
        $this->logger = $logger;
    }
    /**
     * When an order is loaded add our custom attribute 'accredo_fetched_at' to its extension attributes
     *
     * @param EventObserver $observer
     */
    public function execute(EventObserver $observer)
    {
        /** @var \Magento\Sales\Api\Data\OrderInterface $order */
        $order = $observer->getOrder();
        if (!$order) {
            return;
        }

        $orderId = $order->getId();
        $customerId = '';

        if (!$order->getCustomerIsGuest()) {
            $customerId = $order->getCustomerId();
        }

        $couponCode = $order->getCouponCode();
        $appliedRuleIds = $order->getAppliedRuleIds();
        if($orderId && $appliedRuleIds && $couponCode) {
            $this->logger->info(sprintf('+++++Cancel order: %s , appliedRuleIds: %s, couponCode: %s, customerId: %s  ', $orderId, $appliedRuleIds, $couponCode, $customerId));
            if ($customerId) {
                $ruleCustomer = $this->ruleCustomerFactory->create();
                $ruleCustomerData = $ruleCustomer->loadByCustomerRule($customerId, $appliedRuleIds);
                if ($ruleCustomerData->getId()) {
                    if ($ruleCustomerData->getTimesUsed() > 0) {
                        $ruleCustomerData->setTimesUsed($ruleCustomerData->getTimesUsed() - 1);
                        $ruleCustomerData->save();
                    }
                }
            }
            $increment = '';  //reduce usage
            $this->updateCouponUsages($couponCode, $increment, $customerId);
        }
    }


    /**
     * Update the number of coupon usages.
     *
     * @param couponCode $couponCode
     * @param bool $increment
     * @param int $customerId
     */
    private function updateCouponUsages($couponCode, bool $increment, $customerId)
    {
        $currentCoupon = $this->coupon->load($couponCode, 'code');
        if ($currentCoupon->getId()) {
            $this->logger->info(sprintf('+++++Coupon code: %s , increment: %s, timeused: %s', $couponCode, $increment, $currentCoupon->getTimesUsed()));
            if ($increment || $currentCoupon->getTimesUsed() > 0) {
                $currentCoupon->setTimesUsed($currentCoupon->getTimesUsed() + ($increment ? 1 : -1));
                $currentCoupon->save();
            }
            if ($customerId) {
                $this->couponUsage->updateCustomerCouponTimesUsed($customerId, $currentCoupon->getId(), $increment);
            }
        }
    }

}
