<?php

namespace BrittainWynyard\RecentlyViewedWidget\Ui\DataProvider\Product\Listing\Collector;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\Data\ProductRenderInterface;
use Magento\Catalog\Api\Data\ProductRenderExtensionFactory;
use Magento\Catalog\Ui\DataProvider\Product\ProductRenderCollectorInterface;

class AsicsOneCollector implements ProductRenderCollectorInterface
{
    public function __construct(
        private readonly ProductRenderExtensionFactory $productRenderExtensionFactory
    ) {}

    public function collect(ProductInterface $product, ProductRenderInterface $productRender)
    {
        /** @var \Magento\Catalog\Model\Product $product */
        $extensionAttributes = $productRender->getExtensionAttributes()
            ?: $this->productRenderExtensionFactory->create();

        $extensionAttributes->setOneasicsPrice($product->getData('oneasics_price') ?? '');
        $extensionAttributes->setOneasicsPromoTextLoggedIn($product->getData('oneasics_promo_text_logged_in') ?? '');
        $extensionAttributes->setOneasicsPromoTextLoggedOut($product->getData('oneasics_promo_text_logged_out') ?? '');
        $extensionAttributes->setAsicsSiloText($product->getData('asics_silo_text') ?? '');

        $genderValue = $product->getResource()->getAttribute('gender')?->getFrontend()?->getValue($product) ?? '';
        $asicsCategoryValue = $product->getResource()->getAttribute('asics_category')?->getFrontend()?->getValue($product) ?? '';
        $asicsSport1Value = $product->getResource()->getAttribute('asics_sport_1')?->getFrontend()?->getValue($product) ?? '';
        $asicsProductTypeValue = $product->getResource()->getAttribute('asics_product_type')?->getFrontend()?->getValue($product) ?? '';

        $genderPrefix = '';
        if ($genderValue) {
            $genderPrefix = match ($genderValue) {
                'Unisex' => 'Unisex ',
                'Kids' => "Kids' ",
                default => $genderValue . "'s ",
            };
        }

        $finalLabel = trim(
            $genderPrefix . (
            $asicsCategoryValue === 'Shoes'
                ? trim($asicsSport1Value . ' Shoes')
                : $asicsProductTypeValue
            )
        );

        $extensionAttributes->setGenderCategoryLabel($finalLabel);
        // Use cached super swatch count - if not available, show no count
        /** @var \Magento\Catalog\Model\Product $product */
        $colorCount = $product->getData('super_swatch_related_count');
        if ($colorCount && $colorCount > 1) {
            $extensionAttributes->setProductSwatches($colorCount . ' Colours');
        } elseif ($colorCount === 1) {
            $extensionAttributes->setProductSwatches('1 Colour');
        }
        // If no cached count, don't set product_swatches (will be empty/null)

        $productRender->setExtensionAttributes($extensionAttributes);
    }
}
