<?php

namespace BrittainWynyard\OneAsics\Controller\Change;

use BrittainWynyard\OneAsics\Helper\Config;
use BrittainWynyard\OneAsics\OAuth2\Client\Provider\OneAsicsEmail;
use Magento\Framework\App\Action\Context;
use \Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Controller\ResultFactory;
use Psr\Log\LoggerInterface;

/**
 * Class Email
 */
class Email extends \Magento\Framework\App\Action\Action
{
    /**
     * @var OneAsicsEmail
     */
    protected $oneAsicsProviderEmail;

    /**
     * @var Config
     */
    protected $configHelper;

    /**
     * @var LoggerInterface
     */
    protected $logger;


    /**
     * @var CustomerSession
     */
    protected  $customerSession;


    /**
     * @param Context $context
     * @param OneAsicsEmail $oneAsicsProviderEmail
     * @param Config $configHelper
     * @param LoggerInterface $logger
     * @param CustomerSession $customerSession
     */
    public function __construct(
        Context $context,
        OneAsicsEmail $oneAsicsProviderEmail,
        Config $configHelper,
        LoggerInterface $logger,
        CustomerSession $customerSession
    ) {
        $this->oneAsicsProviderEmail = $oneAsicsProviderEmail;
        $this->configHelper = $configHelper;
        $this->logger = $logger;
        $this->customerSession = $customerSession;

        parent::__construct($context);
    }

    /**
     * @return false|\Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

        if (!$this->_request->getParam('state')) {
            $changeEmailUrl = $this->oneAsicsProviderEmail->getAuthorizationUrl();

            if ($this->configHelper->isDebugMode()) {
                $this->logger->info($changeEmailUrl);
            }

            return $this->getResponse()->setRedirect(
                $changeEmailUrl,
                302
            );
        }
        //Check if the customer is logged in
        else if ($this->_request->getParam('confirmed') == 'true') {
            $customerId = $this->customerSession->getId();
            if($customerId) {
                $this->customerSession->logout()->setLastCustomerId($customerId);
            }
            $this->messageManager->addSuccessMessage("Your email is updated. Kindly login again using new email");
            $resultRedirect->setPath('customer/account/login');
            return $resultRedirect;
        }
        else{
            $this->messageManager->addSuccessMessage("Visit inbox to confirm email change");
            $resultRedirect->setPath('customer/account');
            return $resultRedirect;
        }
    }
}
