<?php
/**
 * BrittainWynyard GiftcardAccount Accredo Processor Interface
 *
 * @package BrittainWynyard_GiftcardAccount
 */

namespace BrittainWynyard\GiftcardAccount\Api;

/**
 * Interface for Accredo gift card processing operations
 */
interface AccredoProcessorInterface
{
    /**
     * Sync gift card with Accredo system
     *
     * @param string $code Gift card code
     * @param int|null $websiteId Website ID for the gift card
     * @return bool True if sync was successful
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function syncGiftcard(string $code, ?int $websiteId = null): bool;
}


