<?php

declare(strict_types=1);

namespace BrittainWynyard\Content\Setup\Patch\Data;

use Magento\Cms\Api\BlockRepositoryInterface;
use Magento\Cms\Api\GetBlockByIdentifierInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Store\Model\Store;
use Psr\Log\LoggerInterface;
use Throwable;

// phpcs:disable Generic.Files.LineLength.TooLong

class UpdatePdpPronationBlockPatch implements DataPatchInterface
{
    public function __construct(
        private readonly GetBlockByIdentifierInterface $getBlockByIdentifier,
        private readonly BlockRepositoryInterface $blockRepository,
        private readonly LoggerInterface $logger,
    ) {
    }

    /**
     * Update CMS blocks
     *
     * @return void
     */
    public function apply(): void
    {
        $this->updateBlockContent(
            'pronation_block_Under',
            '<style>#html-body [data-pb-style=PV18653],#html-body [data-pb-style=RD9B32G]{background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll}#html-body [data-pb-style=RD9B32G]{justify-content:flex-start;display:flex;flex-direction:column;border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=PV18653]{align-self:stretch}#html-body [data-pb-style=FFTW8W3]{display:flex;width:100%}#html-body [data-pb-style=X06FHYH]{justify-content:flex-start;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;border-style:none;border-width:1px;border-radius:0;width:50%;align-self:stretch}#html-body [data-pb-style=XH0LX0Q]{text-align:center;margin:0;padding:0;border-style:none}#html-body [data-pb-style=PHQI70V],#html-body [data-pb-style=XDH3XR0]{border-style:none;border-width:1px;border-radius:0;max-width:100%;height:auto}#html-body [data-pb-style=SEYQSO5]{justify-content:center;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;width:50%;align-self:stretch}#html-body [data-pb-style=SEYQSO5],#html-body [data-pb-style=X8KGFK6]{border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=PEEUL57],#html-body [data-pb-style=RWROVB6],#html-body [data-pb-style=VKO763J]{border-style:none;border-width:1px;border-radius:0;margin:0;padding:0}@media only screen and (max-width: 768px) { #html-body [data-pb-style=XH0LX0Q]{border-style:none} }</style><div data-content-type="row" data-appearance="contained" data-element="main"><div data-enable-parallax="0" data-parallax-speed="0.5" data-background-images="{}" data-background-type="image" data-video-loop="true" data-video-play-only-visible="true" data-video-lazy-load="true" data-video-fallback-src="" data-element="inner" data-pb-style="RD9B32G"><div class="pagebuilder-column-group" data-background-images="{}" data-content-type="column-group" data-appearance="default" data-grid-size="12" data-element="main" data-pb-style="PV18653"><div class="pagebuilder-column-line" data-content-type="column-line" data-element="main" data-pb-style="FFTW8W3"><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="X06FHYH"><figure data-content-type="image" data-appearance="full-width" data-element="main" data-pb-style="XH0LX0Q"><img class="pagebuilder-mobile-hidden" src="{{media url=wysiwyg/underPronation_1.gif}}" alt="" title="" data-element="desktop_image" data-pb-style="XDH3XR0"><img class="pagebuilder-mobile-only" src="{{media url=wysiwyg/underPronation_1.gif}}" alt="" title="" data-element="mobile_image" data-pb-style="PHQI70V"></figure></div><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="SEYQSO5"><h3 class="pronation__heading" data-content-type="heading" data-appearance="default" data-element="main" data-pb-style="X8KGFK6">Underpronation</h3><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="VKO763J"><p><strong>Foot type:</strong> High arches</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="PEEUL57"><p><strong>Push Off:</strong> The pressure is on smaller toes on outside of foot.</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="RWROVB6"><p id="G9YIOEP"><strong>How your foot contacts the ground</strong><br>The outer side of the heel hits the ground at an increased angle with little or no normal pronation, causing a large transmission of shock through the lower leg.</p></div></div></div></div></div></div>'
        );
        $this->updateBlockContent(
            'pronation_block_Neutral',
            '<style>#html-body [data-pb-style=FR3Y3R2],#html-body [data-pb-style=JYWEE98]{background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll}#html-body [data-pb-style=JYWEE98]{justify-content:flex-start;display:flex;flex-direction:column;border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=FR3Y3R2]{align-self:stretch}#html-body [data-pb-style=O7UWGQV]{display:flex;width:100%}#html-body [data-pb-style=CWM1MHU]{justify-content:flex-start;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;border-style:none;border-width:1px;border-radius:0;width:50%;align-self:stretch}#html-body [data-pb-style=JII6HUR]{margin:0;padding:0;border-style:none}#html-body [data-pb-style=HBK8SCJ],#html-body [data-pb-style=W1YOX0E]{border-style:none;border-width:1px;border-radius:0;max-width:100%;height:auto}#html-body [data-pb-style=JOCBBKK]{justify-content:center;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;width:50%;align-self:stretch}#html-body [data-pb-style=HRJFD79],#html-body [data-pb-style=JOCBBKK]{border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=EWFJ2OW],#html-body [data-pb-style=IXGIBJ1],#html-body [data-pb-style=WJQT6EA]{border-style:none;border-width:1px;border-radius:0;margin:0;padding:0}@media only screen and (max-width: 768px) { #html-body [data-pb-style=JII6HUR]{border-style:none} }</style><div data-content-type="row" data-appearance="contained" data-element="main"><div data-enable-parallax="0" data-parallax-speed="0.5" data-background-images="{}" data-background-type="image" data-video-loop="true" data-video-play-only-visible="true" data-video-lazy-load="true" data-video-fallback-src="" data-element="inner" data-pb-style="JYWEE98"><div class="pagebuilder-column-group" data-background-images="{}" data-content-type="column-group" data-appearance="default" data-grid-size="12" data-element="main" data-pb-style="FR3Y3R2"><div class="pagebuilder-column-line" data-content-type="column-line" data-element="main" data-pb-style="O7UWGQV"><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="CWM1MHU"><figure data-content-type="image" data-appearance="full-width" data-element="main" data-pb-style="JII6HUR"><img class="pagebuilder-mobile-hidden" src="{{media url=wysiwyg/neutralPronation.gif}}" alt="" title="" data-element="desktop_image" data-pb-style="W1YOX0E"><img class="pagebuilder-mobile-only" src="{{media url=wysiwyg/neutralPronation.gif}}" alt="" title="" data-element="mobile_image" data-pb-style="HBK8SCJ"></figure></div><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="JOCBBKK"><h3 class="pronation__heading" data-content-type="heading" data-appearance="default" data-element="main" data-pb-style="HRJFD79">Neutral</h3><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="WJQT6EA"><p><strong>Foot type:</strong> Normal size arches</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="IXGIBJ1"><p><strong>Push Off:</strong> There is even distribution from the front of the foot.</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="EWFJ2OW"><p><strong>How your foot contacts the ground</strong><br>The foot lands on the outside of the heel, then rolls inward (pronates) to absorb shock and support body weight.</p></div></div></div></div></div></div>'
        );
        $this->updateBlockContent(
            'pronation_block_Over',
            '<style>#html-body [data-pb-style=VQ3DTDJ],#html-body [data-pb-style=YIXN8KY]{background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll}#html-body [data-pb-style=YIXN8KY]{justify-content:flex-start;display:flex;flex-direction:column;border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=VQ3DTDJ]{align-self:stretch}#html-body [data-pb-style=JRJPVYQ]{display:flex;width:100%}#html-body [data-pb-style=N85O9BJ]{justify-content:flex-start;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;border-style:none;border-width:1px;border-radius:0;width:50%;align-self:stretch}#html-body [data-pb-style=G358SED]{text-align:center;margin:0;padding:0;border-style:none}#html-body [data-pb-style=AFEGN2C],#html-body [data-pb-style=R5FOXG7]{border-style:none;border-width:1px;border-radius:0;max-width:100%;height:auto}#html-body [data-pb-style=OCLRBN8]{justify-content:center;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;width:50%;align-self:stretch}#html-body [data-pb-style=AG4236R],#html-body [data-pb-style=OCLRBN8]{border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=EM9P94J],#html-body [data-pb-style=VJLWK55],#html-body [data-pb-style=W4O4RXR]{border-style:none;border-width:1px;border-radius:0;margin:0;padding:0}@media only screen and (max-width: 768px) { #html-body [data-pb-style=G358SED]{border-style:none} }</style><div data-content-type="row" data-appearance="contained" data-element="main"><div data-enable-parallax="0" data-parallax-speed="0.5" data-background-images="{}" data-background-type="image" data-video-loop="true" data-video-play-only-visible="true" data-video-lazy-load="true" data-video-fallback-src="" data-element="inner" data-pb-style="YIXN8KY"><div class="pagebuilder-column-group" data-background-images="{}" data-content-type="column-group" data-appearance="default" data-grid-size="12" data-element="main" data-pb-style="VQ3DTDJ"><div class="pagebuilder-column-line" data-content-type="column-line" data-element="main" data-pb-style="JRJPVYQ"><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="N85O9BJ"><figure data-content-type="image" data-appearance="full-width" data-element="main" data-pb-style="G358SED"><img class="pagebuilder-mobile-hidden" src="{{media url=wysiwyg/overPronation.gif}}" alt="" title="" data-element="desktop_image" data-pb-style="AFEGN2C"><img class="pagebuilder-mobile-only" src="{{media url=wysiwyg/overPronation.gif}}" alt="" title="" data-element="mobile_image" data-pb-style="R5FOXG7"></figure></div><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="OCLRBN8"><h3 class="pronation__heading" data-content-type="heading" data-appearance="default" data-element="main" data-pb-style="AG4236R">Overpronation</h3><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="W4O4RXR"><p><strong>Foot type:</strong> Low arches or flat feet</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="EM9P94J"><p id="D0YSI92"><strong>Push Off:</strong> Big toe and second toe do majority of the work.</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="VJLWK55"><p id="G9YIOEP"><strong>How your foot contacts the ground</strong><br>The foot lands on outside of heel, then rolls inward (pronates) excessively, transferring weight to inner edge instead of ball of the foot.</p></div></div></div></div></div></div>'
        );
        $this->updateBlockContent(
            'pronation_block_Severe Over',
            '<style>#html-body [data-pb-style=TT7LER2],#html-body [data-pb-style=X319D1B]{background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll}#html-body [data-pb-style=X319D1B]{justify-content:flex-start;display:flex;flex-direction:column;border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=TT7LER2]{align-self:stretch}#html-body [data-pb-style=QXMYNXX]{display:flex;width:100%}#html-body [data-pb-style=KA9N62G]{justify-content:flex-start;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;border-style:none;border-width:1px;border-radius:0;width:50%;align-self:stretch}#html-body [data-pb-style=O9N9505]{margin:0;padding:0;border-style:none}#html-body [data-pb-style=A5URBYF],#html-body [data-pb-style=IFBDKIE]{border-style:none;border-width:1px;border-radius:0;max-width:100%;height:auto}#html-body [data-pb-style=EWP9XJR]{justify-content:center;display:flex;flex-direction:column;background-position:left top;background-size:cover;background-repeat:no-repeat;background-attachment:scroll;width:50%;align-self:stretch}#html-body [data-pb-style=EWP9XJR],#html-body [data-pb-style=MAAUXXM]{border-style:none;border-width:1px;border-radius:0}#html-body [data-pb-style=J2O8SXV],#html-body [data-pb-style=LMXNI42],#html-body [data-pb-style=STUB72D]{border-style:none;border-width:1px;border-radius:0;margin:0;padding:0}@media only screen and (max-width: 768px) { #html-body [data-pb-style=O9N9505]{border-style:none} }</style><div data-content-type="row" data-appearance="contained" data-element="main"><div data-enable-parallax="0" data-parallax-speed="0.5" data-background-images="{}" data-background-type="image" data-video-loop="true" data-video-play-only-visible="true" data-video-lazy-load="true" data-video-fallback-src="" data-element="inner" data-pb-style="X319D1B"><div class="pagebuilder-column-group" data-background-images="{}" data-content-type="column-group" data-appearance="default" data-grid-size="12" data-element="main" data-pb-style="TT7LER2"><div class="pagebuilder-column-line" data-content-type="column-line" data-element="main" data-pb-style="QXMYNXX"><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="KA9N62G"><figure data-content-type="image" data-appearance="full-width" data-element="main" data-pb-style="O9N9505"><img class="pagebuilder-mobile-hidden" src="{{media url=wysiwyg/overPronation.gif}}" alt="" title="" data-element="desktop_image" data-pb-style="IFBDKIE"><img class="pagebuilder-mobile-only" src="{{media url=wysiwyg/overPronation.gif}}" alt="" title="" data-element="mobile_image" data-pb-style="A5URBYF"></figure></div><div class="pagebuilder-column" data-content-type="column" data-appearance="full-height" data-background-images="{}" data-element="main" data-pb-style="EWP9XJR"><h3 class="pronation__heading" data-content-type="heading" data-appearance="default" data-element="main" data-pb-style="MAAUXXM">Severe Overpronation</h3><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="LMXNI42"><p><strong>Foot type:</strong> Low arches or flat feet</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="STUB72D"><p><strong>Push Off:</strong> Big toe and second toe do majority of the work.</p></div><div data-content-type="text" data-appearance="default" data-element="main" data-pb-style="J2O8SXV"><p id="G9YIOEP"><strong>How your foot contacts the ground</strong><br>The foot lands on outside of heel, then rolls inward (pronates) excessively, transferring weight to inner edge instead of ball of the foot.</p></div></div></div></div></div></div>'
        );
    }

    /**
     * Update block content by identifier
     *
     * @param string $identifier
     * @param string $content
     * @return void
     */
    private function updateBlockContent(string $identifier, string $content): void
    {
        try {
            $block = $this->getBlockByIdentifier->execute($identifier, Store::DEFAULT_STORE_ID);
            $block->setContent($content);
            $this->blockRepository->save($block);
        } catch (Throwable $exception) {
            $this->logger->warning('Error updating content', ['identifier' => $identifier, 'exception' => $exception]);
        }
    }

    /**
     * @inheritDoc
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public static function getDependencies(): array
    {
        return [];
    }
}
