<?php

namespace BrittainWynyard\CheckoutAttributes\Plugin;


use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Quote\Api\CartItemRepositoryInterface as QuoteItemRepository;


class ConfigProviderPlugin extends \Magento\Framework\Model\AbstractModel
{
    private $checkoutSession;
    private $quoteItemRepository;
    protected $scopeConfig;
    protected $productRepository;

    public function __construct(
        CheckoutSession $checkoutSession,
        QuoteItemRepository $quoteItemRepository,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
    ) {
        $this->_scopeConfig = $scopeConfig;
        $this->checkoutSession = $checkoutSession;
        $this->quoteItemRepository = $quoteItemRepository;
        $this->productRepository = $productRepository;
    }


    public function afterGetConfig(\Magento\Checkout\Model\DefaultConfigProvider $subject, array $result)
    {
        $quoteId = $this->checkoutSession->getQuote()->getId();
        if ($quoteId) {
            $itemOptionCount = count($result['totalsData']['items']);
            $quoteItems = $this->quoteItemRepository->getList($quoteId);
            $isbnOptions = array();
            foreach ($quoteItems as $index => $quoteItem) {
                $quoteItemId = $quoteItem['item_id'];
                $isbnOptions[$quoteItemId] = $quoteItem['isbn'];
            }

            for ($i=0; $i < $itemOptionCount; $i++) {
                $quoteParentId = $result['totalsData']['items'][$i]['item_id'];
                //$objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $productId = $result['quoteItemData'][$i]['product']['entity_id'];
                $productObj = $this->productRepository->getById($productId);

                $productMrktColor = $productObj->getResource()->getAttribute('mkt_colour')->getFrontend()->getValue($productObj);
                $productWidth = $productObj->getResource()->getAttribute('width')->getFrontend()->getValue($productObj);
                $productAsicsCategory = $productObj->getResource()->getAttribute('asics_category')->getFrontend()->getValue($productObj);
                // if($productNote == 'No' || $productNote == 'NA'){
                //    $productNote = '';
                // }
                $result['quoteItemData'][$i]['mkt_colour'] = $productMrktColor;
                $result['quoteItemData'][$i]['width'] = $productWidth;
                $result['quoteItemData'][$i]['asics_category'] = $productAsicsCategory;
                $this->updateQuoteItemDataPricing($result, $i, $productObj);
                json_encode($result);
            }
        }
        return $result;
    }

    protected function updateQuoteItemDataPricing(&$result, $i, $productObj)
    {
        // For gift cards, always set base_original_price to match calculation price
        // Gift cards don't have special prices, so they should never show a "was" price
        if($productObj->getTypeId() === 'giftcard') {
            if(isset($result['quoteItemData'][$i]['base_calculation_price'])) {
                $result['quoteItemData'][$i]['base_original_price'] = $result['quoteItemData'][$i]['base_calculation_price'];
            }
            return;
        }

        if(!isset($result['quoteItemData'][$i]['base_original_price'])) {
            $result['quoteItemData'][$i]['base_original_price'] = $this->getOriginalPrice($productObj);
        }
        if(!isset($result['quoteItemData'][$i]['base_calculation_price']) && isset($result['quoteItemData'][$i]['price_incl_tax'])) {
            $result['quoteItemData'][$i]['base_calculation_price'] = $result['quoteItemData'][$i]['price_incl_tax'];
        }
    }

    protected function getOriginalPrice($product)
    {
        return $product->getPriceInfo()->getPrice('regular_price')->getValue();
    }

}
