<?php

declare(strict_types=1);

namespace BrittainWynyard\CatalogSuperStyle\Model\ResourceModel\Index;

use Magento\Framework\ObjectManagerInterface;

/**
 * Index Collection Factory
 */
class CollectionFactory
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * Constructor
     *
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(ObjectManagerInterface $objectManager)
    {
        $this->objectManager = $objectManager;
    }

    /**
     * Create collection instance
     *
     * @param array $data
     * @return Collection
     */
    public function create(array $data = []): Collection
    {
        return $this->objectManager->create(Collection::class, $data);
    }
}
