<?php

declare(strict_types=1);

namespace BrittainWynyard\CatalogSuperStyle\Model;

use Magento\Framework\Model\AbstractModel;

/**
 * Index Model
 */
class Index extends AbstractModel
{
    /**
     * Initialize resource model
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(\BrittainWynyard\CatalogSuperStyle\Model\ResourceModel\Index::class);
    }

    /**
     * Get super style ID
     *
     * @return string|null
     */
    public function getSuperStyleId(): ?string
    {
        return $this->getData('super_style_id');
    }

    /**
     * Get product ID
     *
     * @return int|null
     */
    public function getProductId(): ?int
    {
        return $this->getData('product_id') ? (int)$this->getData('product_id') : null;
    }

    /**
     * Get website ID
     *
     * @return int|null
     */
    public function getWebsiteId(): ?int
    {
        return $this->getData('website_id') ? (int)$this->getData('website_id') : null;
    }

    /**
     * Set super style ID
     *
     * @param string $superStyleId
     * @return $this
     */
    public function setSuperStyleId(string $superStyleId): self
    {
        return $this->setData('super_style_id', $superStyleId);
    }

    /**
     * Set product ID
     *
     * @param int $productId
     * @return $this
     */
    public function setProductId(int $productId): self
    {
        return $this->setData('product_id', $productId);
    }

    /**
     * Set website ID
     *
     * @param int $websiteId
     * @return $this
     */
    public function setWebsiteId(int $websiteId): self
    {
        return $this->setData('website_id', $websiteId);
    }
}
