<?php


namespace BrittainWynyard\BazaarVoice\Plugin;


use Mirasvit\SeoMarkup\Service\ProductRichSnippetsService;

class ProductsRichSnippetsServicePlugin
{

    /**
     * @param \Mirasvit\SeoMarkup\Service\ProductRichSnippetsService $subject
     * @param callable $proceed
     * @param Product $product
     */
    public function aroundGetJsonData(\Mirasvit\SeoMarkup\Service\ProductRichSnippetsService $subject, callable $proceed, $product)
    {
        $data = $proceed($product);
        //BV requires and ID in structured data @see https://knowledge.bazaarvoice.com/wp-content/conversations/en_US/Display/display_integration.html#step-2-update-product-json-ld-markup-on-your-pdps
        $data['@id'] = $product->getUrlInStore();
        return $data;
    }
}
