<?php

namespace Asics\Verifone\Cron;

use Magento\Sales\Api\OrderManagementInterface;
use Magento\Sales\Model\Order;
use Psr\Log\LoggerInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;

class CancelPendingOrders
{
    const PAYMENT_METHOD = 'verifone_hosted';

    protected LoggerInterface $_logger;
    protected CollectionFactory $_orderCollectionFactory;
    private OrderManagementInterface $orderManagement;

    /**
     * @param CollectionFactory $orderCollectionFactory
     * @param OrderManagementInterface $orderManagement
     * @param LoggerInterface $logger
     */
    public function __construct(
        CollectionFactory $orderCollectionFactory,
        OrderManagementInterface $orderManagement,
        LoggerInterface   $logger
    ) {
        $this->_orderCollectionFactory = $orderCollectionFactory;
        $this->orderManagement = $orderManagement;
        $this->_logger = $logger;
    }

    public function execute()
    {
        $this->_logger->info("Cancel pending Verifone orders - starting cron");
        $orders = $this->_orderCollectionFactory->create();
        $orders->getSelect()->join(
            ['payment' => $orders->getTable('sales_order_payment')],
            'main_table.entity_id = payment.parent_id',
            ['method']
        );
        $orders->addFieldToFilter('main_table.state', Order::STATE_NEW);
        $orders->addFieldToFilter('main_table.status', 'pending');
        $orders->addFieldToFilter('payment.method', self::PAYMENT_METHOD);
        $orders->getSelect()->where(
            new \Zend_Db_Expr('TIME_TO_SEC(TIMEDIFF(CURRENT_TIMESTAMP, `updated_at`)) >= 14400')
        );

        foreach ($orders->getAllIds() as $entityId) {
            $this->_logger->info("Cancel pending order id " . $entityId);
            $this->orderManagement->cancel((int) $entityId);
        }

        $this->_logger->info("Cancel pending Verifone orders completed - stopping cron");
        return $this;
    }
}
