define([
    'jquery',
    'underscore',
    'uiComponent',
    'Magento_Checkout/js/model/quote',
    'Asics_Checkout/js/action/recollect-totals',
    'Asics_Checkout/js/model/subscriber',
    'Magento_Checkout/js/model/shipping-service',
    'Magento_Checkout/js/model/shipping-rate-processor/new-address',
    'Magento_Checkout/js/model/totals',
    'Magento_SalesRule/js/view/payment/discount',
    'rjsResolver'
], function ($, _, Component, quote, recollect, subscriber, shippingService, shippingProcessor, totals, discount, resolver) {
    'use strict';

    return Component.extend({
        previousShippingMethodData: {},
        
        initialize: function () {
            this._super();

            resolver(function() {
                this.isPageLoaded = true;

                totals.getItems().subscribe(this.storeOldItems, this, "beforeChange");
                totals.getItems().subscribe(this.recollectOnItems, this);
            }.bind(this));

            discount().isApplied.subscribe(function () {
                recollect(true);
            });

            quote.shippingAddress.subscribe(function (newShippingAddress) {
                // while page is loading do not recollect, should be recollected after shipping rates
                // for avoid extra requests to server
                if (this.isPageLoaded && this._isNeededRecollectShipping(newShippingAddress, this.city, this.street)) {
                    this.city = newShippingAddress.city;
                    this.street = newShippingAddress.street;
                    if (newShippingAddress) {
                        recollect();
                    }
                }
            }.bind(this));

            //for invalid shipping address update
            shippingService.getShippingRates().subscribe(function (rates) {
                if (!this._isVirtualQuote()) {
                    recollect();
                }
            }.bind(this));

            quote.shippingMethod.subscribe(this.storeOldMethod, this, "beforeChange");
            quote.shippingMethod.subscribe(this.recollectOnShippingMethod, this);

            return this;
        },

        /**
         * Store before change shipping method, because sometimes shipping methods updates always (not by change)
         *
         * @param {Object} oldMethod
         */
        storeOldMethod: function (oldMethod) {
            this.previousShippingMethodData = oldMethod;
        },

        recollectOnShippingMethod: function (newMethodData) {
            if (!_.isEqual(this.previousShippingMethodData, newMethodData)) {
                recollect();
            }
        },

        /**
         * Store before change cart items
         *
         * @param {Array} oldItems
         * @since 1.3.13
         */
        storeOldItems: function (oldItems) {
            this.previousItemsData = this._prepareArrayForCompare(oldItems);
        },

        /**
         * Recollect totals on cart items update
         *
         * @param {Array} newItems
         * @since 1.3.13 improve compatibility with modules which allow update cart items on checkout page
         *        and ajax update cart items
         */
        recollectOnItems: function (newItems) {
            if (!_.isEqual(this.previousItemsData, this._prepareArrayForCompare(newItems))) {
                // totals should be already collected, trigger subscribers
                // for more stability but less performance can be replaced with recollect(true);
                subscriber.isLoading.valueHasMutated();
            }
        },

        /**
         * Remove all not simple types from array items
         *
         * @param {Array} data
         * @returns {Array}
         * @private
         * @since 1.3.13
         */
        _prepareArrayForCompare: function (data) {
            var result = [],
                itemData = {};

            _.each(data, function(item) {
                itemData = _.pick(item, function (value) {
                    return !_.isObject(value);
                });
                result.push(itemData);
            }.bind(this));

            return result;
        },

        _isVirtualQuote: function () {
            return quote.isVirtual()
                || window.checkoutConfig.activeCarriers && window.checkoutConfig.activeCarriers.length === 0;
        },

        _isNeededRecollectShipping: function (newShippingAddress, city, street) {
            return !this._isVirtualQuote()
                && (
                    newShippingAddress
                    && (newShippingAddress.city || newShippingAddress.street)
                    && (newShippingAddress.city != city || !_.isEqual(newShippingAddress.street, street)));
        }
    });
});
