define([
    'jquery',
    'mage/utils/wrapper',
    'underscore',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/resource-url-manager',
    'Magento_Checkout/js/model/error-processor',
    'mage/storage',
    'Magento_Checkout/js/model/totals',
    'Magento_Checkout/js/model/cart/cache',
    'Magento_Customer/js/customer-data'
    ], function ($, wrapper, _, quote, resourceUrlManager, errorProcessor, storage, totals, cartCache, customerData) {
        'use strict';

    return function (originalAction) {
        return wrapper.wrap(originalAction, function (originalMethod, callbacks, deferred) {
            deferred = deferred || $.Deferred();
            totals.isLoading(true);
            if (quote.shippingAddress() && quote.shippingMethod()) {
                let serviceUrl,
                    payload,
                    address;
                serviceUrl = resourceUrlManager.getUrlForTotalsEstimationForNewAddress(quote);
                address = quote.shippingAddress();
                payload = {
                    addressInformation: {
                        address: _.pick(address, cartCache.requiredFields)
                    }
                };
    
                if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {
                    payload.addressInformation['shipping_method_code'] = quote.shippingMethod()['method_code'];
                    payload.addressInformation['shipping_carrier_code'] = quote.shippingMethod()['carrier_code'];
                }
    
                return storage.post(
                    serviceUrl, JSON.stringify(payload), false
                ).done(function (result) {
                    var proceed = true;
    
                    totals.isLoading(false);
    
                    if (callbacks.length > 0) {
                        $.each(callbacks, function (index, callback) {
                            proceed = proceed && callback();
                        });
                    }
    
                    if (proceed) {
                        let data = {
                            totals: result,
                            address: address,
                            cartVersion: customerData.get('cart')()['data_id'],
                            shippingMethodCode: null,
                            shippingCarrierCode: null
                        };
    
                        if (quote.shippingMethod() && quote.shippingMethod()['method_code']) {
                            data.shippingMethodCode = quote.shippingMethod()['method_code'];
                            data.shippingCarrierCode = quote.shippingMethod()['carrier_code'];
                        }
    
                        quote.setTotals(result);
                        cartCache.set('cart-data', data);
                        deferred.resolve();
                    }
                }).fail(function (response) {
                    totals.isLoading(false);
                    deferred.reject();
                    errorProcessor.process(response);
                }).always(function () {
                    totals.isLoading(false);
                });
    
            } else {
                return storage.get(
                    resourceUrlManager.getUrlForCartTotals(quote),
                    false
                ).done(function (response) {
                    var proceed = true;
    
                    totals.isLoading(false);
    
                    if (callbacks.length > 0) {
                        $.each(callbacks, function (index, callback) {
                            proceed = proceed && callback();
                        });
                    }
    
                    if (proceed) {
                        quote.setTotals(response);
                        deferred.resolve();
                    }
                }).fail(function (response) {
                    totals.isLoading(false);
                    deferred.reject();
                    errorProcessor.process(response);
                }).always(function () {
                    totals.isLoading(false);
                });
            }
        });
    };
});