define([
    'jquery',
    'ko'
], function ($, ko,) {
    'use strict';

    return function (uiComponent) {
        return uiComponent.extend({
            defaults : {
                today: new Date(),
                cardNumber : ko.observable('cardNumber'),
                cardHolderName : ko.observable('cardHolderName'),
                expiryMonth : ko.observable('expiryMonth'),
                expiryYear : ko.observable('expiryYear')
            },

            initialize() {
                this._super();

                this.paymentOptionChanged();

                return this;
            },

            pad: function (source) {
                if (source.length < 2)
                    return "0" + source;
                return source;
            },

            paymentOptionChanged: function() {
                let currentYear = this.today.getFullYear();
                let currentMonth = this.today.getMonth() + 1;

                this.cardNumber("");
                this.cardHolderName("");
                this.expiryMonth(this.pad(currentMonth.toString()));
                this.expiryYear(currentYear.toString());
            },
        });
    };
});
