define([
    'jquery',
    'underscore',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/action/set-shipping-information',
    'Magento_Checkout/js/model/step-navigator',
    'Magento_Checkout/js/model/checkout-data-resolver',
    'Magento_Checkout/js/checkout-data',
    'Magento_Checkout/js/model/shipping-rates-validator',
    'uiRegistry',
    'mage/translate',
    'Magento_Customer/js/model/address-list',
    'Magento_Checkout/js/action/select-shipping-address'
], function (
    $,
    _,
    quote,
    setShippingInformationAction,
    stepNavigator,
    checkoutDataResolver,
    checkoutData,
    shippingRatesValidator,
    registry,
    $t,
    addressList,
    selectShippingAddress
) {
    'use strict';

    return function (Component) {
        return Component.extend({
            /**
             * Set shipping information handler
             */
            setShippingInformation: function () {
                var shippingAddress = quote.shippingAddress();
                if (!(shippingAddress.lastname === 'Store')) {
                    let storePickupComponent = registry.get(
                        'checkout.steps.store-pickup.store-selector.store-step-faux-store-selector'
                    );
                    if (storePickupComponent) {
                        var nonPickupShippingMethod = _.find(
                            storePickupComponent.rates(),
                            function (rate) {
                                return (
                                    rate['carrier_code'] !== storePickupComponent.rate['carrier_code'] &&
                                    rate['method_code'] !== storePickupComponent.rate['method_code']
                                );
                            }
                        );

                        if(nonPickupShippingMethod.carrier_code && addressList().length > 0) {  //which means exist nonpickupshipping
                            if (addressList()['0'] && shippingAddress.getKey() === addressList()['0'].getKey()) {
                                selectShippingAddress(addressList()['0']);
                                checkoutData.setSelectedShippingAddress(addressList()['0'].getKey());
                                shippingAddress = Object.assign({}, addressList()['0']);
                            }
                        }
                    }
                }

                var addressData = $('#co-shipping-form').serializeArray(),
                    addr        = {};

                for (var i = 0; i < addressData.length; i++){
                    var record        = addressData[i];
                    addr[record.name] = record.value;
                }

                registry.async('checkoutProvider')(function (checkoutProvider) {
                    checkoutProvider.set(
                        'storedFormAddress',
                        $.extend(true, {}, checkoutProvider.get('shippingAddress'), shippingAddress)
                    );
                });

                if (addr['street[0]']) {
                    shippingAddress['street'] = [addr['street[0]']];
                }

                if ((shippingAddress['street'] && shippingAddress['street'].length < 1) || !shippingAddress['city'] || (shippingAddress['customAttributes'] && shippingAddress['customAttributes'].suburb && !shippingAddress['customAttributes'].suburb.value)) {
                    this.errorValidationMessage(
                        $t('Please select an address to ship to.')
                    );

                    return false;
                }

                if (this.validateShippingInformation()) {
                    quote.billingAddress(null);
                    checkoutDataResolver.resolveBillingAddress();

                    registry.async('checkoutProvider')(function (checkoutProvider) {
                        var shippingAddressData = checkoutData.getShippingAddressFromData(),
                            fieldsetName        = 'checkout.steps.shipping-step.shippingAddress.shipping-address-fieldset';

                        if (shippingAddressData) {
                            checkoutProvider.set(
                                'shippingAddress',
                                $.extend(true, checkoutProvider.get('shippingAddress'), shippingAddressData)
                            );
                        }
                        checkoutProvider.on('shippingAddress', function (shippingAddrsData) {
                            checkoutData.setShippingAddressFromData(shippingAddrsData);
                        });
                        shippingRatesValidator.initFields(fieldsetName);
                    });
                    setShippingInformationAction().done(
                        function () {
                            stepNavigator.next();
                        }
                    );
                }
            }
        });
    }
});
