define([
    'jquery',
    'mage/url',
    'Magento_Checkout/js/model/step-navigator'
], function ($, url, stepNavigator) {
    'use strict';

    const mixin = {

        isProcessed: function (item) {
            let stepCode = item.code,
                $body = $('body');

            if (stepCode === 'shipping') {
                $body.addClass('checkout-payment-step');
                $body.removeClass('checkout-shipping-step');
            } else {
                $body.addClass('checkout-shipping-step');
                $body.removeClass('checkout-payment-step');
            }
            return stepNavigator.isProcessed(item.code);
        }
    };

    return function (Component) {
        return Component.extend(mixin);
    };
});
