define([
    'jquery',
    'Overdose_DataLayer/js/cookies'
], function ($, cookies) {
    'use strict';
    var mixin = {
        checkoutPaymentTermsBlock: window.checkoutPaymentTermsBlock,

        handleChangeClick: function () {
            const paySecureBtn = $(".payment-method._active .action.checkout");
            if (typeof window.dataLayer === 'undefined') {
                window.dataLayer = [];
            }
            try {
                let paymentInfo = JSON.parse(cookies.getCookie('od-add-payment-info'))
                if (paymentInfo) {
                    window.dataLayer.push(paymentInfo);
                }
            } catch (err) {
            }

            /* Do nothing when the Verifon Iframe was loaded */
            if (paySecureBtn.attr('id') !== 'verifone_hosted'
                || !paySecureBtn.parent().siblings('#payment_form_container_iframe').length) {
                paySecureBtn.click();
            }
        }
    };
    return function (Component) {
        return Component.extend(mixin);
    }
});
