define([
    'ko',
    'jquery',
    'uiComponent',
    'Magento_Customer/js/model/customer',
    'matchMedia'
], function (ko, $, Component, customer, mediaCheck) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_Checkout/oneasics-login',
            isVisible: ko.observable(false),
            parentClassWhenVisible: '_has-oneasics-login-block',
            mobileQuery: '(max-width: 767px)'
        },

        initialize: function () {
            this._super();
            let self = this;

            mediaCheck({
                media: self.mobileQuery,
                entry: function () {
                    self.isVisible(!customer.isLoggedIn());

                    customer.isLoggedIn.subscribe(function (loggedIn) {
                        self.isVisible(!loggedIn);
                    });

                    self.toggleParentClass();
                },
                exit: function () {
                    self.isVisible(false);
                }
            });

            return this;
        },

        toggleParentClass: function () {
            let self = this;
            this.isVisible.subscribe(function (value) {
                self.updateParentClass(value);
            });
            this.updateParentClass(this.isVisible());
        },

        updateParentClass: function (shouldAdd) {
            let $el = $('#' + this.name);
            let $parent = $el.parent();

            if ($parent.length) {
                if (shouldAdd) {
                    $parent.addClass(this.parentClassWhenVisible);
                } else {
                    $parent.removeClass(this.parentClassWhenVisible);
                }
            }
        }
    });
});
