/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'mage/url',
    'Magento_Customer/js/customer-data',
    'Magento_Customer/js/model/customer',
    'ko',
    'underscore',
    'jquery-ui-modules/core',
    'jquery-ui-modules/dialog'
], function ($, url, customerData, customer, ko, _) {
    'use strict';

    var sidebarInitialized = false,
        addToCartCalls = 0,
        miniCart;

    miniCart = $('[data-block=\'minicart\']');

    /**
     * @return {Boolean}
     */
    function initSidebar() {
        if (miniCart.data('mageSidebar')) {
            miniCart.sidebar('update');
        }

        if (!$('[data-role=product-item]').length) {
            return false;
        }
        miniCart.trigger('contentUpdated');

        if (sidebarInitialized) {
            return false;
        }
        sidebarInitialized = true;
        miniCart.sidebar({
            'targetElement': 'div.block.block-minicart',
            'url': {
                'checkout': window.checkout.checkoutUrl,
                'update': window.checkout.updateItemQtyUrl,
                'remove': window.checkout.removeItemUrl,
                'loginUrl': window.checkout.customerLoginUrl,
                'isRedirectRequired': window.checkout.isRedirectRequired
            },
            'button': {
                'checkout': '#top-cart-btn-checkout',
                'remove': '#mini-cart a.action.delete',
                'close': '#btn-minicart-close'
            },
            'showcart': {
                'parent': 'span.counter',
                'qty': 'span.counter-number',
                'label': 'span.counter-label'
            },
            'minicart': {
                'list': '#mini-cart',
                'content': '#minicart-content-wrapper',
                'qty': 'div.items-total',
                'subtotal': 'div.subtotal span.price',
                'maxItemsVisible': window.checkout.minicartMaxItemsVisible
            },
            'item': {
                'qty': ':input.cart-item-qty',
                'button': ':button.update-cart-item'
            },
            'confirmMessage': $.mage.__('Are you sure you would like to remove this item from the shopping cart?')
        });
    }

    miniCart.on('dropdowndialogopen', function () {
        initSidebar();
    });

    return function (Component) {
        return Component.extend({

            /**
             * @override
             */
            initialize: function () {
                var self = this;

                return this._super();
            },

            isLoading: ko.observable(false),
            initSidebar: initSidebar,

            /**
             * Close mini shopping cart.
             */
            closeMinicart: function () {
                $('[data-block="minicart"].active').find('[data-role="dropdownDialog"]').dropdownDialog('close');
            },

            buildBaseUrl: function (urlString) {
                return url.build(urlString);
            },

            isLoggedIn: function () {
                var customerObj = customerData.get('customer');

                return !!customerObj().firstname;
            },

            /**
             * Update mini shopping cart content.
             *
             * @param {Object} updatedCart
             * @returns void
             */
            update: function (updatedCart) {
                _.each(updatedCart, function (value, key) {
                    if (!this.cart.hasOwnProperty(key)) {
                        this.cart[key] = ko.observable();
                    }

                    this.cart[key](value);
                }, this);


                var afterpayValue = this.getAfterpayValue();

                if (afterpayValue == 0) {
                    //hide afterpay minicart
                    if (document.querySelector('#afterpayMinicart')) {
                        document.querySelector('#afterpayMinicart').classList.remove('active')
                    }
                } else {
                    //show afterpay minicart
                    //add value
                    if (document.querySelector('#afterpayMinicart')) {
                        document.querySelector('#afterpayMinicart').classList.add('active')
                        document.querySelector('#minicartAfterpayValue').textContent = afterpayValue;
                    }
                }

                $(".afterpay-modal-popup-trigger").on("click", function () {
                    $('#afterpay-modal-popup').show();
                    $('#afterpay-modal-popup').modal('openModal');
                });
            },

            getAfterpayValue: function () {
                if (this.cart.subtotalAmount) {
                    var subtotal = this.cart.subtotalAmount._latestValue;
                    var afterpayValue = subtotal / 4;

                    $(".afterpay-modal-popup-trigger").on("click", function () {
                        $('#afterpay-modal-popup').show();
                        $('#afterpay-modal-popup').modal('openModal');
                    });

                    return afterpayValue.toFixed(2);
                } else {
                    return this.cart.subtotal;
                }
            }
        });
    }
});

