define([
    'jquery',
    'jquery-ui-modules/core',
    'jquery-ui-modules/widget',
    'mage/dropdown'
], function ($) {
    'use strict';

    $.widget('base.dropdownDialog', $.mage.dropdownDialog, {
        options: {
            miniCartClass: '.showcart',
            sideView: false
        },

        /**
         * extend default functionality to bind the opener for dropdown
         * @private
         */
        _create: function () {
            this._super();

            if(this.options.sideView) {
                $('body').addClass('side-cart');
            }
        },

        open: function () {
            this._super();
            if(this.options.triggerTarget === this.options.miniCartClass && this.options.sideView) {
                $('body').addClass('fixed');
            }
        },

        close: function () {
            this._super();
            if(this.options.triggerTarget === this.options.miniCartClass && this.options.sideView) {
                $('body').removeClass('fixed');
            }
        }
    });

    return $.base.dropdownDialog;
});
