define([
    'jquery'
], function ($) {
    return function () {
        return $.widget('mage.sidebar', $.mage.sidebar, {
            /**
             * @private
             */
            _initContent: function () {
                var self = this,  events = {};
                /**
                 * @param {jQuery.Event} event
                 */
                events['change ' + 'select.js-details-qty__select'] = function (event) {
                    var selectedValue = parseInt(event.currentTarget.value, 10);
                    var itemId = event.currentTarget.dataset.cartItem;
                    var elem = $(event.currentTarget);

                    this._ajax(this.options.url.update, {
                        'item_id': itemId,
                        'item_qty': selectedValue
                    }, elem, this._updateItemQtyAfter);
                };

                /**
                 * @param {jQuery.Event} event
                 */
                events['click ' + this.options.button.remove] =  function (event) {
                    event.stopPropagation();
                    self._removeItem($(event.currentTarget));
                };

                this._on(this.element, events);

                // window.setTimeout(()=>{
                    $('#minicartAfterpay').detach().appendTo('#afterpayMinicartDropzone');
                // }, 500)
            },
        });
    };
});
