define(
    [
        'jquery',
        'mage/mage',
        'Bss_Quickview/js/jquery.magnific-popup.min'
    ],
    function ($) {
        "use strict";
        $.widget(
            'bss.bss_config',
            {
                options: {
                    productUrl: '',
                    buttonText: '',
                    isEnabled: false,
                    baseUrl: '',
                    productImageWrapper: '',
                    productItemInfo: ''
                },

                _create: function () {
                    let self = this;

                    if (window.searchspringProductsLoaded) {
                        this.renderButton();
                        this._EventListener();
                    } else {
                        this.renderButton();
                        this._EventListener();
                    }

                    $(window).on('product-cards:init', function () {
                        self.renderButton();
                        self._EventListener();
                    });
                },

                renderButton: function () {
                    var $widget = this,
                        id_product,
                        productImageWrapper = '.' + this.options.productImageWrapper,
                        productItemInfo = '.' +  this.options.productItemInfo;

                    if ($widget.options.isEnabled == 1) {
                        $(productImageWrapper).each(
                            function () {
                                if ($(this).find('.actions-primary input[name="product"]').val() != '') {
                                    id_product = $(this).find('.actions-primary input[name="product"]').val();
                                }
                                if (!id_product) {
                                    id_product = $(this).find('.price-box').data('product-id');
                                }
                                if (!id_product) {
                                    id_product = $(this).attr('id');
                                    id_product = id_product.replace('product-item-info_', '');
                                }

                                if (id_product) {
                                    let itemInfo = $(this).parents(".product-item").find(productItemInfo)[0];
                                    let buttons = $(itemInfo).find('.bss-bt-quickview').length;

                                    if (buttons === 0) {
                                        $(this).parents(".product-item").find(productItemInfo).append('<div id="quickview-' + id_product + '" class="bss-bt-quickview"><a class="bss-quickview" data-quickview-url="' + $widget.options.productUrl + 'id/' + id_product + '" href="javascript:void(0);" ><span>' + $widget.options.buttonText + '</span></a></div>');
                                    }
                                }
                            }
                        )
                    }
                },

                _EventListener: function () {
                    var $widget = this;
                    if ($widget.options.isEnabled == 1) {

                        $('a.mailto').click(
                            function (e) {
                                e.preventDefault();
                                window.top.location.href = $(this).attr('href');
                                return true;
                            }
                        );

                        $('body, #layer-product-list').on(
                            'contentUpdated',
                            function () {
                                $('.bss-bt-quickview').remove();
                                $widget.renderButton();
                            }
                        );

                        $(document).on(
                            'click',
                            '.bss-quickview',
                            function () {
                                var prodUrl = $(this).attr('data-quickview-url');
                                if (prodUrl.length) {
                                    $widget.openPopup(prodUrl);
                                }
                            }
                        );
                    }
                },

                openPopup: function (prodUrl) {
                    var $widget = this,
                        url = $widget.options.baseUrl + 'bss_quickview/index/updatecart';

                    if (!prodUrl.length) {
                        return false;
                    }

                    $.magnificPopup.open(
                        {
                            items: {
                                src: prodUrl
                            },
                            type: 'iframe',
                            closeOnBgClick: false,
                            scrolling: false,
                            preloader: true,
                            tLoading: '',
                            callbacks: {
                                open: function () {
                                    $('.mfp-preloader').css('display', 'block');
                                    $("iframe.mfp-iframe").contents().find("html").addClass("bss_loader");
                                },
                                beforeClose: function () {
                                    $.ajax(
                                        {
                                            url: url,
                                            method: "POST"
                                        }
                                    );
                                },
                                close: function () {
                                    $('.mfp-preloader').css('display', 'none');
                                }
                            }
                        }
                    );
                }
            }
        );
        return $.bss.bss_config;
    }
);
