define(
    [
        'Magento_Checkout/js/model/quote',
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/action/set-billing-address',
        'Verifone_Hosted/js/action/set-payment-method',
        'Magento_Checkout/js/action/select-payment-method',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_Checkout/js/model/full-screen-loader',
        'Magento_Ui/js/model/messageList',
        'Magento_Customer/js/customer-data',
        'domReady!' // awaits for DOM to be loaded
    ],
    function (
        quote,
        $,
        Component,
        placeOrderAction,
        setBillingAddressAction,
        setPaymentMethodAction,
        selectPaymentMethodAction,
        additionalValidators,
        fullScreenLoader,
        globalMessageList,
        customerData
    ) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'Verifone_Hosted/payment/verifone_hosted',
                code: "verifone_hosted",
                customRedirect: true,
                shouldPlaceOrder: true,
            },

            continueToVerifone: function (data, event) {
                var self = this;

                if (this.validate() && additionalValidators.validate()) {
                    this.selectPaymentMethod();
                    var setBillingInfo = setBillingAddressAction();
                    setBillingInfo.done(function() {
                        self.placeOrder();
                    });
                    return false;
                }
            },
            isShowLegend: function () {
                return true;
            },
            placeOrder: function()
            {
                var self = this;

                var settings = window.checkoutConfig.payment.verifone_hosted;

                if (settings.shouldPlaceOrder === '1') {
                    placeOrderAction(self.getData(), self.messageContainer)
                        .done(function () {
                            self.redirect(settings);
                        }).fail(function (e) {
                        globalMessageList.addErrorMessage({
                            message: e.responseJSON.message
                        });
                    }).always(function () {
                        fullScreenLoader.stopLoader();
                    });
                } else {
                    self.redirect(settings);
                }

                return false;
            },

            redirect: function(settings)
            {
                let url = settings.redirectUrl;
                $.ajax({
                    showLoader: true,
                    url: url,
                    type: 'get',
                    context: this,
                    data: {isAjax: 1,email: quote.guestEmail},
                    dataType: 'json',
                    success: function (response, data) {
                        if (response.result === "success") {
                            customerData.invalidate(['cart']);
                            if (response.method === "iframe") {
                                var appendTo = $('#actions_toolbar');
                                $('<div id="payment_form_container_iframe" style=" padding:10px; height: 470px; overflow: auto"></div>').appendTo(appendTo);
                                $('#continue_verifone').remove();

                                function loadIframe(src, containerId) {
                                    var script = document.createElement('script');
                                    script.src = src;
                                    script.async = true;
                                    document.getElementById(containerId).append(script);
                                }

                                loadIframe(
                                    response.url,
                                    'payment_form_container_iframe'
                                );
                                setTimeout(function() {
                                    $('iframe').css("outline","none");
                                    $('iframe').css("border","none");
                                    $('iframe').css("height","100%");
                                }, 1000);
                            } else if (typeof response.redirect !== "undefined") {
                                if (settings.shouldPlaceOrder !== '1') {
                                    setPaymentMethodAction();
                                }
                                window.location.href = response.redirect;
                            } else {
                                fullScreenLoader.stopLoader();
                            }
                        } else {
                            globalMessageList.addErrorMessage({
                                message: response.messages
                            });

                            // redirect to cancel the order and load the original quote
                            if (settings.shouldPlaceOrder === '1') {
                                window.location.href = url;
                            }
                        }
                    },
                    error: function (response, data) {
                        alert('An error occurred. Try again!');
                    },
                    complete: function (response) {
                        fullScreenLoader.stopLoader();
                    }
                });

            }
        });
    });
